/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.message.helper;

import com.atlassian.jira.issue.Issue;
import io.atlassian.fugue.Option;
import javax.annotation.concurrent.Immutable;

@Immutable
class IssueCache {
    private final boolean reindexRequired;
    private final boolean indexed;
    private final Option<Issue> issue;

    IssueCache() {
        this((Option<Issue>)Option.none(), false, false);
    }

    private IssueCache(Option<Issue> issue, boolean reindexRequired, boolean indexed) {
        this.issue = issue;
        this.reindexRequired = reindexRequired;
        this.indexed = indexed;
    }

    boolean wasIndexed() {
        return this.indexed;
    }

    boolean isReindexRequired() {
        return this.reindexRequired;
    }

    Option<Issue> getIssueResult() {
        return this.issue;
    }

    boolean hasIssueResult() {
        return this.issue.isDefined();
    }

    IssueCache withReindexRequired(boolean reindexRequired) {
        return new IssueCache(this.issue, reindexRequired, this.indexed);
    }

    IssueCache withIssueResult(Issue issueResult) {
        return new IssueCache((Option<Issue>)Option.option((Object)issueResult), this.reindexRequired, this.indexed);
    }

    IssueCache withoutIssueResult() {
        return new IssueCache((Option<Issue>)Option.none(), this.reindexRequired, this.indexed);
    }

    IssueCache withIndexed() {
        return new IssueCache(this.issue, this.reindexRequired, true);
    }
}

