/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.message;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.fugue.Option;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageCache;
import com.atlassian.servicedesk.plugins.automation.internal.execution.message.RuleMessageCacheImpl;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class RuleMessageImpl
implements RuleMessage {
    @TenantAware(value=TenancyScope.TENANTED)
    private Map<String, String> data;
    private RuleMessageCache cache;

    RuleMessageImpl() {
        this(Collections.emptyMap());
    }

    RuleMessageImpl(Map<String, String> data) {
        Assertions.notNull((String)"data", data);
        this.data = ImmutableMap.copyOf(data);
        this.cache = new RuleMessageCacheImpl();
    }

    RuleMessageImpl(Map<String, String> data, RuleMessageCache cache) {
        Assertions.notNull((String)"data", data);
        Assertions.notNull((String)"cache", (Object)cache);
        this.data = ImmutableMap.copyOf(data);
        this.cache = new RuleMessageCacheImpl(cache);
    }

    @Nonnull
    public Option<String> getValue(String key) {
        if (StringUtils.isBlank((String)key)) {
            return Option.none();
        }
        return Option.option((Object)this.data.get(key));
    }

    @Nonnull
    public Map<String, String> getAllValues() {
        return this.data;
    }

    @Nonnull
    public RuleMessageCache getCache() {
        return this.cache;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("data", this.data).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RuleMessageImpl)) {
            return false;
        }
        RuleMessageImpl that = (RuleMessageImpl)o;
        return this.data.equals(that.data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }
}

