/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.log;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.When;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.WhenHandlerConfiguration;
import com.atlassian.servicedesk.plugins.automation.internal.execution.log.AuditLogExecutionStatus;
import com.atlassian.servicedesk.plugins.automation.internal.execution.log.RuleSetAuditLogComponentDetailData;
import com.atlassian.servicedesk.plugins.automation.internal.module.WhenHandlerData;
import com.atlassian.servicedesk.plugins.automation.internal.module.WhenHandlerDisplayData;
import com.atlassian.servicedesk.plugins.automation.internal.module.WhenHandlerManager;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Pair;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WhenAuditLogManager {
    private final WhenHandlerManager whenHandlerManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Autowired
    public WhenAuditLogManager(WhenHandlerManager whenHandlerManager, JiraAuthenticationContext jiraAuthenticationContext) {
        this.whenHandlerManager = whenHandlerManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    List<RuleSetAuditLogComponentDetailData> getWhenHandlerData(When when) {
        return when.getWhenHandlerConfigurations().stream().map(this::mapWhenConfigToDisplayString).map(pair -> new RuleSetAuditLogComponentDetailData((Boolean)pair.left(), AuditLogExecutionStatus.NOT_EXECUTED, (String)pair.right(), (Option<String>)Option.none())).collect(Collectors.toList());
    }

    private Pair<Boolean, String> mapWhenConfigToDisplayString(WhenHandlerConfiguration config) {
        return (Pair)this.whenHandlerManager.getConfiguredWhenHandlerData(this.getLoggedInUser(), config.getModuleKey(), config.getData()).fold(error -> new Pair((Object)true, (Object)error.getErrorMessage()), data -> new Pair((Object)false, (Object)this.getWhenHandlerDisplayString((WhenHandlerData)data)));
    }

    private String getWhenHandlerDisplayString(WhenHandlerData whenHandlerData) {
        WhenHandlerDisplayData displayData = whenHandlerData.getWhenHandlerDisplayData();
        return (String)displayData.getLabel().fold(displayData::getName, label -> displayData.getName() + ": " + label);
    }

    private ApplicationUser getLoggedInUser() {
        return this.jiraAuthenticationContext.getLoggedInUser();
    }
}

