/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.log;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.If;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.IfConditionConfiguration;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.ComponentConfigurationImpl;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.IfConditionExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.IfExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.log.AuditLogExecutionStatus;
import com.atlassian.servicedesk.plugins.automation.internal.execution.log.RuleSetAuditLogComponentDetailData;
import com.atlassian.servicedesk.plugins.automation.internal.module.IfConditionData;
import com.atlassian.servicedesk.plugins.automation.internal.module.IfConditionDisplayData;
import com.atlassian.servicedesk.plugins.automation.internal.module.IfConditionManager;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Pair;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IfAuditLogManager {
    private final IfConditionManager ifConditionManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Autowired
    public IfAuditLogManager(IfConditionManager ifConditionManager, JiraAuthenticationContext jiraAuthenticationContext) {
        this.ifConditionManager = ifConditionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    List<RuleSetAuditLogComponentDetailData> getIfConditionData(If ifCondition, Option<IfExecution> ifExecution) {
        return ifCondition.getIfConditionConfigurations().stream().map(condition -> {
            Option<IfConditionExecution> executionForCondition = this.getExecutionForCondition((IfConditionConfiguration)condition, ifExecution);
            return this.mapIfConfigToDisplayString((IfConditionConfiguration)condition, executionForCondition);
        }).collect(Collectors.toList());
    }

    private Option<IfConditionExecution> getExecutionForCondition(IfConditionConfiguration config, Option<IfExecution> ifExecution) {
        return ifExecution.flatMap(execution -> this.getIfConditionExecutions((ComponentConfigurationImpl)config, (IfExecution)execution));
    }

    private Option<IfConditionExecution> getIfConditionExecutions(ComponentConfigurationImpl config, IfExecution execution) {
        return Option.fromOptional(execution.getIfConditionExecutions().stream().filter(exec -> exec.getIfConditionId() == config.getId()).findAny());
    }

    private RuleSetAuditLogComponentDetailData mapIfConfigToDisplayString(IfConditionConfiguration config, Option<IfConditionExecution> ifConditionExecution) {
        Pair displayData = (Pair)this.ifConditionManager.getConfiguredIfConditionData(this.getLoggedInUser(), config.getModuleKey(), config.getData()).fold(error -> new Pair((Object)true, (Object)error.getErrorMessage()), data -> new Pair((Object)false, (Object)this.getIfConditionDisplayString((IfConditionData)data)));
        AuditLogExecutionStatus status = this.getStatus(ifConditionExecution);
        Option outcomeMessage = ifConditionExecution.flatMap(execution -> execution.getResult().getMessage());
        return new RuleSetAuditLogComponentDetailData((Boolean)displayData.left(), status, (String)displayData.right(), (Option<String>)outcomeMessage);
    }

    private String getIfConditionDisplayString(IfConditionData ifConditionData) {
        IfConditionDisplayData displayData = ifConditionData.getIfConditionDisplayData();
        return (String)displayData.getLabel().fold(displayData::getName, label -> displayData.getName() + ": " + label);
    }

    private AuditLogExecutionStatus getStatus(Option<IfConditionExecution> ifConditionExecution) {
        return (AuditLogExecutionStatus)((Object)ifConditionExecution.fold(() -> AuditLogExecutionStatus.NOT_EXECUTED, execution -> AuditLogExecutionStatus.fromIfConditionOutcome((IfConditionExecution.Outcome)((Object)((Object)execution.getResult().getOutcome())))));
    }

    private ApplicationUser getLoggedInUser() {
        return this.jiraAuthenticationContext.getLoggedInUser();
    }
}

