/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.history.dao.querydsl;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.plugins.automation.internal.bootstrap.database.schema.querydsl.Tables;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.common.dao.QueryDslDao;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.common.dao.QueryDslDaoHelper;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewThenActionExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.ThenActionExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.ThenActionExecutionImpl;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.ImmutableList;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import io.atlassian.fugue.Option;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

final class ThenActionExecutionDao
extends QueryDslDao {
    ThenActionExecutionDao(DatabaseAccessor databaseAccessor, QueryDslDaoHelper helper) {
        super(databaseAccessor, helper);
    }

    long deleteThenActionExecutionHistoryEntries(DatabaseConnection connection, long referenceEpoch) {
        return connection.delete((RelationalPath)Tables.THEN_ACTION_EXECUTION).where((Predicate)Tables.THEN_ACTION_EXECUTION.THEN_EXECUTION_ID.in((SubQueryExpression)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)SQLExpressions.select(Tables.THEN_EXECUTION.ID).from((Expression)Tables.THEN_EXECUTION)).innerJoin((EntityPath)Tables.IF_THEN_EXECUTION)).on((Predicate)Tables.THEN_EXECUTION.IF_THEN_EXECUTION_ID.eq(Tables.IF_THEN_EXECUTION.ID))).innerJoin((EntityPath)Tables.RULE_EXECUTION)).on((Predicate)Tables.IF_THEN_EXECUTION.RULE_EXECUTION_ID.eq(Tables.RULE_EXECUTION.ID))).where((Predicate)Tables.RULE_EXECUTION.FINISH_TIME_MILLIS.lt((Number)referenceEpoch)))).execute();
    }

    public void create(NewThenActionExecution toInsert, long associatedThenExecutionId, DatabaseConnection connection) {
        Assertions.notNull((String)"toInsert", (Object)toInsert);
        Assertions.notNull((String)"connection", (Object)connection);
        this.insertThenActionExecution(toInsert, associatedThenExecutionId, connection);
    }

    private void insertThenActionExecution(NewThenActionExecution toInsert, long associatedThenExecutionId, DatabaseConnection connection) {
        SQLInsertClause insertStatement = connection.insert((RelationalPath)Tables.THEN_ACTION_EXECUTION).set(Tables.THEN_ACTION_EXECUTION.START_TIME_MILLIS, (Object)toInsert.getStartTime().getMillis()).set(Tables.THEN_ACTION_EXECUTION.FINISH_TIME_MILLIS, (Object)toInsert.getFinishTime().getMillis()).set((Path)Tables.THEN_ACTION_EXECUTION.OUTCOME, (Object)((ThenActionExecution.Outcome)((Object)toInsert.getResult().getOutcome())).name()).set((Path)Tables.THEN_ACTION_EXECUTION.MESSAGE, toInsert.getResult().getMessage().getOrNull()).set(Tables.THEN_ACTION_EXECUTION.THEN_EXECUTION_ID, (Object)associatedThenExecutionId).set(Tables.THEN_ACTION_EXECUTION.THEN_ACTION_CONFIG_ID, (Object)toInsert.getThenActionId());
        this.helper.executeSingleRowInsertReturningId(connection, insertStatement, "Failed to insert new row into " + Tables.THEN_ACTION_EXECUTION.getTableName());
    }

    List<ThenActionExecution> getForThenExecutionWithId(long thenExecutionId, Option<String> executedBy, DatabaseConnection connection) {
        List results = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select((Expression[])ArrayUtils.addAll((Object[])Tables.THEN_ACTION_EXECUTION.all(), (Object[])new Path[]{Tables.THEN_ACTION_CONFIG.MODULE_KEY})).from((Expression)Tables.THEN_ACTION_EXECUTION)).leftJoin((EntityPath)Tables.THEN_ACTION_CONFIG)).on((Predicate)Tables.THEN_ACTION_EXECUTION.THEN_ACTION_CONFIG_ID.eq(Tables.THEN_ACTION_CONFIG.ID))).where((Predicate)Tables.THEN_ACTION_EXECUTION.THEN_EXECUTION_ID.eq((Object)thenExecutionId))).orderBy(Tables.THEN_ACTION_EXECUTION.ID.asc())).fetch();
        return this.loadThenActionExecutionsFromDbRows(results, executedBy);
    }

    private List<ThenActionExecution> loadThenActionExecutionsFromDbRows(List<Tuple> dbRows, Option<String> executedBy) {
        ImmutableList.Builder loadedThenActionExecs = ImmutableList.builder();
        for (Tuple dbRow : dbRows) {
            loadedThenActionExecs.add((Object)this.loadThenActionExecutionFromDbRow(dbRow, executedBy));
        }
        return loadedThenActionExecs.build();
    }

    private ThenActionExecution loadThenActionExecutionFromDbRow(Tuple dbRow, Option<String> executedBy) {
        return new ThenActionExecutionImpl((Long)dbRow.get(Tables.THEN_ACTION_EXECUTION.ID), (Long)dbRow.get(Tables.THEN_ACTION_EXECUTION.THEN_ACTION_CONFIG_ID), (String)dbRow.get((Expression)Tables.THEN_ACTION_CONFIG.MODULE_KEY), QueryDslDaoHelper.convertLongToDateTime((Long)dbRow.get(Tables.THEN_ACTION_EXECUTION.START_TIME_MILLIS)), QueryDslDaoHelper.convertLongToDateTime((Long)dbRow.get(Tables.THEN_ACTION_EXECUTION.FINISH_TIME_MILLIS)), executedBy, QueryDslDaoHelper.constructExecutionResult((String)dbRow.get((Expression)Tables.THEN_ACTION_EXECUTION.OUTCOME), ThenActionExecution.Outcome.class, (String)dbRow.get((Expression)Tables.THEN_ACTION_EXECUTION.MESSAGE)));
    }
}

