/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.history.dao.querydsl;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.plugins.automation.internal.bootstrap.database.schema.querydsl.Tables;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.common.dao.QueryDslDao;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.common.dao.QueryDslDaoHelper;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewIfConditionExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.IfConditionExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.IfConditionExecutionImpl;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.ImmutableList;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import io.atlassian.fugue.Option;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

final class IfConditionExecutionDao
extends QueryDslDao {
    IfConditionExecutionDao(DatabaseAccessor databaseAccessor, QueryDslDaoHelper helper) {
        super(databaseAccessor, helper);
    }

    long deleteIfConditionExecutionHistoryEntries(DatabaseConnection connection, long referenceEpoch) {
        return connection.delete((RelationalPath)Tables.IF_CONDITION_EXECUTION).where((Predicate)Tables.IF_CONDITION_EXECUTION.IF_EXECUTION_ID.in((SubQueryExpression)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)SQLExpressions.select(Tables.IF_EXECUTION.ID).from((Expression)Tables.IF_EXECUTION)).innerJoin((EntityPath)Tables.IF_THEN_EXECUTION)).on((Predicate)Tables.IF_EXECUTION.IF_THEN_EXECUTION_ID.eq(Tables.IF_THEN_EXECUTION.ID))).innerJoin((EntityPath)Tables.RULE_EXECUTION)).on((Predicate)Tables.IF_THEN_EXECUTION.RULE_EXECUTION_ID.eq(Tables.RULE_EXECUTION.ID))).where((Predicate)Tables.RULE_EXECUTION.FINISH_TIME_MILLIS.lt((Number)referenceEpoch)))).execute();
    }

    public void create(NewIfConditionExecution toInsert, long associatedIfExecutionId, DatabaseConnection connection) {
        Assertions.notNull((String)"toInsert", (Object)toInsert);
        Assertions.notNull((String)"connection", (Object)connection);
        this.insertIfConditionExecution(toInsert, associatedIfExecutionId, connection);
    }

    private void insertIfConditionExecution(NewIfConditionExecution toInsert, long associatedIfExecutionId, DatabaseConnection connection) {
        SQLInsertClause insertStatement = connection.insert((RelationalPath)Tables.IF_CONDITION_EXECUTION).set(Tables.IF_CONDITION_EXECUTION.START_TIME_MILLIS, (Object)toInsert.getStartTime().getMillis()).set(Tables.IF_CONDITION_EXECUTION.FINISH_TIME_MILLIS, (Object)toInsert.getFinishTime().getMillis()).set((Path)Tables.IF_CONDITION_EXECUTION.OUTCOME, (Object)((IfConditionExecution.Outcome)((Object)toInsert.getResult().getOutcome())).name()).set((Path)Tables.IF_CONDITION_EXECUTION.MESSAGE, toInsert.getResult().getMessage().getOrNull()).set(Tables.IF_CONDITION_EXECUTION.IF_EXECUTION_ID, (Object)associatedIfExecutionId).set(Tables.IF_CONDITION_EXECUTION.IF_CONDITION_CONFIG_ID, (Object)toInsert.getIfConditionId());
        this.helper.executeSingleRowInsertReturningId(connection, insertStatement, "Failed to insert new row into " + Tables.IF_CONDITION_EXECUTION.getTableName());
    }

    public List<IfConditionExecution> getForIfConditionWithId(long ifExecutionId, Option<String> executedBy, DatabaseConnection connection) {
        List results = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select((Expression[])ArrayUtils.addAll((Object[])Tables.IF_CONDITION_EXECUTION.all(), (Object[])new Path[]{Tables.IF_CONDITION_CONFIG.MODULE_KEY})).from((Expression)Tables.IF_CONDITION_EXECUTION)).leftJoin((EntityPath)Tables.IF_CONDITION_CONFIG)).on((Predicate)Tables.IF_CONDITION_EXECUTION.IF_CONDITION_CONFIG_ID.eq(Tables.IF_CONDITION_CONFIG.ID))).where((Predicate)Tables.IF_CONDITION_EXECUTION.IF_EXECUTION_ID.eq((Object)ifExecutionId))).orderBy(Tables.IF_CONDITION_EXECUTION.ID.asc())).fetch();
        return this.loadIfConditionExecutionsFromDbRows(results, executedBy);
    }

    private List<IfConditionExecution> loadIfConditionExecutionsFromDbRows(List<Tuple> dbRows, Option<String> executedBy) {
        ImmutableList.Builder loadedIfCondExecs = ImmutableList.builder();
        for (Tuple dbRow : dbRows) {
            loadedIfCondExecs.add((Object)this.loadIfConditionExecutionFromDbRow(dbRow, executedBy));
        }
        return loadedIfCondExecs.build();
    }

    private IfConditionExecution loadIfConditionExecutionFromDbRow(Tuple dbRow, Option<String> executedBy) {
        return new IfConditionExecutionImpl((Long)dbRow.get(Tables.IF_CONDITION_EXECUTION.IF_EXECUTION_ID), (Long)dbRow.get(Tables.IF_CONDITION_EXECUTION.IF_CONDITION_CONFIG_ID), (String)dbRow.get((Expression)Tables.IF_CONDITION_CONFIG.MODULE_KEY), QueryDslDaoHelper.convertLongToDateTime((Long)dbRow.get(Tables.IF_CONDITION_EXECUTION.START_TIME_MILLIS)), QueryDslDaoHelper.convertLongToDateTime((Long)dbRow.get(Tables.IF_CONDITION_EXECUTION.FINISH_TIME_MILLIS)), executedBy, QueryDslDaoHelper.constructExecutionResult((String)dbRow.get((Expression)Tables.IF_CONDITION_EXECUTION.OUTCOME), IfConditionExecution.Outcome.class, (String)dbRow.get((Expression)Tables.IF_CONDITION_EXECUTION.MESSAGE)));
    }
}

