/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.history.dao.querydsl;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilderService;
import com.atlassian.servicedesk.plugins.automation.internal.bootstrap.database.schema.querydsl.QExecutionRuleMessageItem;
import com.atlassian.servicedesk.plugins.automation.internal.bootstrap.database.schema.querydsl.Tables;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.common.dao.QueryDslDao;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.common.dao.QueryDslDaoHelper;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.ExecutionHistoryFilter;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewIfThenExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewRuleExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.dao.ExecutionHistoryDao;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.dao.querydsl.IfThenExecutionDao;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.IfThenExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.RuleExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.RuleExecutionImpl;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.RuleExecutionSummary;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.RuleExecutionSummaryImpl;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.ImmutableMap;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
final class ExecutionHistoryDaoImpl
extends QueryDslDao
implements ExecutionHistoryDao {
    private static final Logger log = LoggerFactory.getLogger(ExecutionHistoryDaoImpl.class);
    private static final int ISSUE_KEY_QUERY_LIMIT = 5;
    private final IfThenExecutionDao ifThenExecutionDao;
    private final RuleMessageBuilderService ruleMessageBuilderService;

    @Autowired
    public ExecutionHistoryDaoImpl(DatabaseAccessor databaseAccessor, QueryDslDaoHelper helper, RuleMessageBuilderService ruleMessageBuilderService) {
        super(databaseAccessor, helper);
        this.ifThenExecutionDao = new IfThenExecutionDao(databaseAccessor, helper);
        this.ruleMessageBuilderService = ruleMessageBuilderService;
    }

    @Override
    public long create(@Nonnull NewRuleExecution toCreate) {
        Assertions.notNull((String)"toCreate", (Object)toCreate);
        return (Long)this.databaseAccessor.runInTransaction(connection -> {
            log.debug("Saving a new rule execution record in the database");
            long id = this.insertRuleExecution(toCreate, (DatabaseConnection)connection);
            log.debug("New rule execution record saved in the database with id: '{}'", (Object)id);
            return id;
        });
    }

    private long insertRuleExecution(NewRuleExecution toInsert, DatabaseConnection connection) {
        SQLInsertClause insertStatement = connection.insert((RelationalPath)Tables.RULE_EXECUTION).set(Tables.RULE_EXECUTION.START_TIME_MILLIS, (Object)toInsert.getStartTime().getMillis()).set(Tables.RULE_EXECUTION.FINISH_TIME_MILLIS, (Object)toInsert.getFinishTime().getMillis()).set((Path)Tables.RULE_EXECUTION.OUTCOME, (Object)((RuleExecution.Outcome)((Object)toInsert.getResult().getOutcome())).name()).set((Path)Tables.RULE_EXECUTION.MESSAGE, toInsert.getResult().getMessage().getOrNull()).set(Tables.RULE_EXECUTION.RULE_ID, (Object)toInsert.getRuleId()).set((Path)Tables.RULE_EXECUTION.EXECUTOR_USER_KEY, toInsert.getExecutedBy().getOrNull());
        long insertedRuleExecutionId = this.helper.executeSingleRowInsertReturningId(connection, insertStatement, "Failed to insert new row into " + Tables.RULE_EXECUTION.getTableName());
        this.insertIfThenExecutions(toInsert.getIfThenExecutions(), insertedRuleExecutionId, connection);
        this.insertRuleMessage(toInsert.getMessage(), insertedRuleExecutionId, connection);
        return insertedRuleExecutionId;
    }

    private void insertIfThenExecutions(List<NewIfThenExecution> executionsToInsert, long associatedRuleExecutionId, DatabaseConnection connection) {
        for (NewIfThenExecution toInsert : executionsToInsert) {
            this.ifThenExecutionDao.create(toInsert, associatedRuleExecutionId, connection);
        }
    }

    private void insertRuleMessage(Option<RuleMessage> toInsertOpt, long associatedRuleExecutionId, DatabaseConnection connection) {
        if (toInsertOpt.isEmpty() || this.hasNoData((RuleMessage)toInsertOpt.get())) {
            return;
        }
        RuleMessage toInsert = (RuleMessage)toInsertOpt.get();
        SQLInsertClause batchInsertStatement = connection.insert((RelationalPath)Tables.EXECUTION_RULE_MESSAGE_ITEM);
        for (Map.Entry messageEntry : toInsert.getAllValues().entrySet()) {
            batchInsertStatement.set(Tables.EXECUTION_RULE_MESSAGE_ITEM.RULE_EXECUTION_ID, (Object)associatedRuleExecutionId);
            batchInsertStatement.set((Path)Tables.EXECUTION_RULE_MESSAGE_ITEM.RULE_MESSAGE_KEY, messageEntry.getKey());
            batchInsertStatement.set((Path)Tables.EXECUTION_RULE_MESSAGE_ITEM.RULE_MESSAGE_VALUE, messageEntry.getValue());
            batchInsertStatement.addBatch();
        }
        this.helper.executeExpectingNRowUpdates(batchInsertStatement, toInsert.getAllValues().size(), "Failed to insert rule execution rule message items for rule execution with id '" + associatedRuleExecutionId + "'");
    }

    private boolean hasNoData(RuleMessage toCheck) {
        return toCheck.getAllValues().isEmpty();
    }

    @Override
    @Nonnull
    public Option<RuleExecution> get(long id) {
        return (Option)this.databaseAccessor.runInTransaction(connection -> {
            log.debug("Retrieving rule execution record in the database with id: '{}'", (Object)id);
            Option<RuleExecution> retrievedOpt = this.getWithConnection(id, (DatabaseConnection)connection);
            log.debug(retrievedOpt.isDefined() ? "Retrieved rule execution record in the database with id: '{}'" : "No rule execution record found in the database with id: '{}' ", (Object)id);
            return retrievedOpt;
        });
    }

    @Override
    public long deleteHistoryEntriesOlderThanNinetyDays() {
        long referenceEpoch = DateTime.now().minusDays(90).getMillis();
        return (Long)this.databaseAccessor.run(connection -> this.ifThenExecutionDao.deleteExecutionHistoryEntries((DatabaseConnection)connection, referenceEpoch) + this.deleteExecutionRuleMessageItem((DatabaseConnection)connection, referenceEpoch) + this.deleteRuleExecutionHistoryEntries((DatabaseConnection)connection, referenceEpoch));
    }

    private long deleteExecutionRuleMessageItem(DatabaseConnection connection, long referenceEpoch) {
        return connection.delete((RelationalPath)Tables.EXECUTION_RULE_MESSAGE_ITEM).where((Predicate)Tables.EXECUTION_RULE_MESSAGE_ITEM.RULE_EXECUTION_ID.in((SubQueryExpression)((SQLQuery)SQLExpressions.select(Tables.RULE_EXECUTION.ID).from((Expression)Tables.RULE_EXECUTION)).where((Predicate)Tables.RULE_EXECUTION.FINISH_TIME_MILLIS.lt((Number)referenceEpoch)))).execute();
    }

    private long deleteRuleExecutionHistoryEntries(DatabaseConnection connection, long referenceEpoch) {
        return connection.delete((RelationalPath)Tables.RULE_EXECUTION).where((Predicate)Tables.RULE_EXECUTION.FINISH_TIME_MILLIS.lt((Number)referenceEpoch)).execute();
    }

    @Override
    @Nonnull
    public List<RuleExecutionSummary> getByRuleSetId(long id, long limit, ExecutionHistoryFilter filter) {
        return (List)this.databaseAccessor.runInTransaction(connection -> {
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select(new Expression[]{Tables.RULE_EXECUTION.EXECUTOR_USER_KEY, Tables.RULE_EXECUTION.FINISH_TIME_MILLIS, Tables.RULE_EXECUTION.ID, Tables.RULE_EXECUTION.MESSAGE, Tables.RULE_EXECUTION.OUTCOME, Tables.RULE_EXECUTION.RULE_ID, Tables.RULE_EXECUTION.START_TIME_MILLIS, Tables.EXECUTION_RULE_MESSAGE_ITEM.RULE_MESSAGE_VALUE}).from((Expression)Tables.RULE_EXECUTION)).leftJoin((EntityPath)Tables.RULE)).on((Predicate)Tables.RULE_EXECUTION.RULE_ID.eq(Tables.RULE.ID))).leftJoin((EntityPath)Tables.RULE_SET_REVISION)).on((Predicate)Tables.RULE_SET_REVISION.ID.eq(Tables.RULE.RULESET_REVISION_ID))).leftJoin((EntityPath)Tables.RULE_SET)).on((Predicate)Tables.RULE_SET_REVISION.RULE_SET_ID.eq(Tables.RULE_SET.ID))).leftJoin((EntityPath)Tables.EXECUTION_RULE_MESSAGE_ITEM)).on((Predicate)Tables.EXECUTION_RULE_MESSAGE_ITEM.RULE_EXECUTION_ID.eq(Tables.RULE_EXECUTION.ID).and((Predicate)Tables.EXECUTION_RULE_MESSAGE_ITEM.RULE_MESSAGE_KEY.eq((Object)"issueKey")))).where((Predicate)this.getWhereClause(id, filter))).limit(limit)).orderBy(Tables.RULE_EXECUTION.FINISH_TIME_MILLIS.desc())).fetch();
            return list.stream().map(this::getRuleExecutionSummaryFromRow).collect(Collectors.toList());
        });
    }

    public BooleanExpression getWhereClause(long id, ExecutionHistoryFilter filter) {
        BooleanExpression expression = Tables.RULE_SET.ID.eq((Object)id);
        if (!filter.getIssueKeys().isEmpty()) {
            expression = expression.and((Predicate)Tables.EXECUTION_RULE_MESSAGE_ITEM.RULE_MESSAGE_VALUE.in(filter.getIssueKeys()));
        }
        if (filter.isHideSuccessfulExecutions()) {
            expression = expression.and((Predicate)Tables.RULE_EXECUTION.OUTCOME.in((Object[])new String[]{RuleExecution.Outcome.ERROR.name(), RuleExecution.Outcome.NOT_EXECUTED.name()}));
        }
        return expression;
    }

    @Override
    @Nonnull
    public List<String> getIssueKeysByRuleSetId(long id, String issueKeySearchPattern) {
        return (List)this.databaseAccessor.runInTransaction(connection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select((Expression)Tables.EXECUTION_RULE_MESSAGE_ITEM.RULE_MESSAGE_VALUE).from((Expression)Tables.RULE_EXECUTION)).leftJoin((EntityPath)Tables.RULE)).on((Predicate)Tables.RULE_EXECUTION.RULE_ID.eq(Tables.RULE.ID))).leftJoin((EntityPath)Tables.RULE_SET_REVISION)).on((Predicate)Tables.RULE_SET_REVISION.ID.eq(Tables.RULE.RULESET_REVISION_ID))).leftJoin((EntityPath)Tables.RULE_SET)).on((Predicate)Tables.RULE_SET_REVISION.RULE_SET_ID.eq(Tables.RULE_SET.ID))).leftJoin((EntityPath)Tables.EXECUTION_RULE_MESSAGE_ITEM)).on((Predicate)Tables.EXECUTION_RULE_MESSAGE_ITEM.RULE_EXECUTION_ID.eq(Tables.RULE_EXECUTION.ID))).where((Predicate)Tables.RULE_SET.ID.eq((Object)id).and((Predicate)this.getIssueKeySearchPatternWhereClause(issueKeySearchPattern)))).limit(5L)).groupBy((Expression)Tables.EXECUTION_RULE_MESSAGE_ITEM.RULE_MESSAGE_VALUE)).orderBy(Tables.EXECUTION_RULE_MESSAGE_ITEM.RULE_MESSAGE_VALUE.asc())).fetch());
    }

    public BooleanExpression getIssueKeySearchPatternWhereClause(String issueKeySearchPattern) {
        BooleanExpression expression = Tables.EXECUTION_RULE_MESSAGE_ITEM.RULE_MESSAGE_KEY.eq((Object)"issueKey");
        if (StringUtils.isNotBlank((String)issueKeySearchPattern)) {
            return expression.and((Predicate)Tables.EXECUTION_RULE_MESSAGE_ITEM.RULE_MESSAGE_VALUE.contains(issueKeySearchPattern));
        }
        return expression;
    }

    private Option<RuleExecution> getWithConnection(long id, DatabaseConnection connectionToUse) {
        Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connectionToUse.select((Expression[])ArrayUtils.addAll((Object[])Tables.RULE_EXECUTION.all(), (Object[])new Path[]{Tables.RULE_SET_REVISION.NAME})).from((Expression)Tables.RULE_EXECUTION)).leftJoin((EntityPath)Tables.RULE)).on((Predicate)Tables.RULE_EXECUTION.RULE_ID.eq(Tables.RULE.ID))).leftJoin((EntityPath)Tables.RULE_SET_REVISION)).on((Predicate)Tables.RULE_SET_REVISION.ID.eq(Tables.RULE.RULESET_REVISION_ID))).where((Predicate)Tables.RULE_EXECUTION.ID.eq((Object)id))).fetchOne();
        if (null == tuple) {
            return Option.none();
        }
        RuleExecution retrievedRuleExecution = this.getRuleExecutionFromRow(tuple, connectionToUse);
        return Option.some((Object)retrievedRuleExecution);
    }

    private RuleExecutionSummary getRuleExecutionSummaryFromRow(Tuple ruleExecutionRow) {
        Option executedByOption = Option.option((Object)ruleExecutionRow.get((Expression)Tables.RULE_EXECUTION.EXECUTOR_USER_KEY));
        return new RuleExecutionSummaryImpl((Long)ruleExecutionRow.get(Tables.RULE_EXECUTION.ID), (Long)ruleExecutionRow.get(Tables.RULE_EXECUTION.RULE_ID), QueryDslDaoHelper.convertLongToDateTime((Long)ruleExecutionRow.get(Tables.RULE_EXECUTION.START_TIME_MILLIS)), QueryDslDaoHelper.convertLongToDateTime((Long)ruleExecutionRow.get(Tables.RULE_EXECUTION.FINISH_TIME_MILLIS)), (Option<String>)executedByOption, QueryDslDaoHelper.constructExecutionResult((String)ruleExecutionRow.get((Expression)Tables.RULE_EXECUTION.OUTCOME), RuleExecution.Outcome.class, (String)ruleExecutionRow.get((Expression)Tables.RULE_EXECUTION.MESSAGE)), (String)ruleExecutionRow.get((Expression)Tables.EXECUTION_RULE_MESSAGE_ITEM.RULE_MESSAGE_VALUE));
    }

    private RuleExecution getRuleExecutionFromRow(Tuple ruleExecutionRow, DatabaseConnection connectionToUse) {
        Option<RuleMessage> ruleMessage = this.getRuleMessageForRuleExecution((Long)ruleExecutionRow.get(Tables.RULE_EXECUTION.ID), connectionToUse);
        Option executedByOption = Option.option((Object)ruleExecutionRow.get((Expression)Tables.RULE_EXECUTION.EXECUTOR_USER_KEY));
        List<IfThenExecution> ifThenExecutions = this.ifThenExecutionDao.getAllForRuleExecutionWithId((Long)ruleExecutionRow.get(Tables.RULE_EXECUTION.ID), (Option<String>)executedByOption, connectionToUse);
        return new RuleExecutionImpl((Long)ruleExecutionRow.get(Tables.RULE_EXECUTION.ID), (Long)ruleExecutionRow.get(Tables.RULE_EXECUTION.RULE_ID), (String)ruleExecutionRow.get((Expression)Tables.RULE_SET_REVISION.NAME), ifThenExecutions, ruleMessage, QueryDslDaoHelper.convertLongToDateTime((Long)ruleExecutionRow.get(Tables.RULE_EXECUTION.START_TIME_MILLIS)), QueryDslDaoHelper.convertLongToDateTime((Long)ruleExecutionRow.get(Tables.RULE_EXECUTION.FINISH_TIME_MILLIS)), (Option<String>)executedByOption, QueryDslDaoHelper.constructExecutionResult((String)ruleExecutionRow.get((Expression)Tables.RULE_EXECUTION.OUTCOME), RuleExecution.Outcome.class, (String)ruleExecutionRow.get((Expression)Tables.RULE_EXECUTION.MESSAGE)));
    }

    private Option<RuleMessage> getRuleMessageForRuleExecution(Long ruleExecutionId, DatabaseConnection connectionToUse) {
        List returnedRows = ((SQLQuery)((SQLQuery)connectionToUse.select(QueryDslDaoHelper.constructor(QExecutionRuleMessageItem.Row.class, Tables.EXECUTION_RULE_MESSAGE_ITEM)).from((Expression)Tables.EXECUTION_RULE_MESSAGE_ITEM)).where((Predicate)Tables.EXECUTION_RULE_MESSAGE_ITEM.RULE_EXECUTION_ID.eq((Object)ruleExecutionId))).fetch();
        if (returnedRows.isEmpty()) {
            return Option.none();
        }
        RuleMessage loadedRuleMessage = this.loadRuleMessageFromDbRows(returnedRows);
        return Option.some((Object)loadedRuleMessage);
    }

    private RuleMessage loadRuleMessageFromDbRows(List<QExecutionRuleMessageItem.Row> dbRows) {
        ImmutableMap.Builder configDataMap = ImmutableMap.builder();
        for (QExecutionRuleMessageItem.Row row : dbRows) {
            configDataMap.put((Object)row.ruleMessageKey, (Object)row.ruleMessageValue);
        }
        return this.ruleMessageBuilderService.builder().putAllValues((Map)configDataMap.build()).build();
    }
}

