/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.builder;

import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewThenActionExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewThenActionExecutionImpl;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.builder.ExecutionResultBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.builder.NewThenExecutionBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.ThenActionExecution;
import com.atlassian.util.concurrent.Assertions;
import io.atlassian.fugue.Option;
import org.joda.time.DateTime;

public final class NewThenActionExecutionBuilder {
    private final NewThenExecutionBuilder parent;
    private Long thenActionId;
    private DateTime startTime;
    private DateTime finishTime;
    private Option<String> executedBy;
    private ExecutionResultBuilder<ThenActionExecution.Outcome, NewThenActionExecutionBuilder> executionResultBuilder;

    public static NewThenActionExecutionBuilder newBuilder() {
        return new NewThenActionExecutionBuilder();
    }

    private NewThenActionExecutionBuilder() {
        this.parent = null;
        this.executionResultBuilder = new ExecutionResultBuilder(this);
    }

    NewThenActionExecutionBuilder(NewThenExecutionBuilder parent) {
        this.parent = parent;
        this.executionResultBuilder = new ExecutionResultBuilder(this);
    }

    NewThenActionExecutionBuilder(NewThenExecutionBuilder parent, NewThenActionExecution newThenActionExecution) {
        this.parent = parent;
        this.executionResultBuilder = new ExecutionResultBuilder(this, newThenActionExecution.getResult());
        this.thenActionId(newThenActionExecution.getThenActionId());
        this.startTime(newThenActionExecution.getStartTime());
        this.finishTime(newThenActionExecution.getFinishTime());
        this.executedBy(newThenActionExecution.getExecutedBy());
    }

    public NewThenActionExecutionBuilder thenActionId(long theThenActionId) {
        this.thenActionId = theThenActionId;
        return this;
    }

    public NewThenActionExecutionBuilder startTime(DateTime theStartTime) {
        this.startTime = theStartTime;
        return this;
    }

    public NewThenActionExecutionBuilder finishTime(DateTime theFinishTime) {
        this.finishTime = theFinishTime;
        return this;
    }

    public NewThenActionExecutionBuilder executedBy(Option<String> theUserThatExecuted) {
        this.executedBy = theUserThatExecuted;
        return this;
    }

    public ExecutionResultBuilder<ThenActionExecution.Outcome, NewThenActionExecutionBuilder> executionResult() {
        return this.executionResultBuilder;
    }

    public NewThenExecutionBuilder endThenActionExecution() {
        return this.parent;
    }

    public NewThenActionExecution build() {
        this.validate();
        return new NewThenActionExecutionImpl(this.thenActionId, this.startTime, this.finishTime, this.executedBy, this.executionResultBuilder.build());
    }

    private void validate() {
        Assertions.notNull((String)"ifConditionId", (Object)this.thenActionId);
        Assertions.notNull((String)"startTime", (Object)this.startTime);
        Assertions.notNull((String)"finishTime", (Object)this.finishTime);
        Assertions.notNull((String)"executedBy", this.executedBy);
    }
}

