/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.builder;

import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewIfExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewIfThenExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewIfThenExecutionImpl;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewThenExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.builder.ExecutionResultBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.builder.NewIfExecutionBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.builder.NewRuleExecutionBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.builder.NewThenExecutionBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.IfThenExecution;
import com.atlassian.util.concurrent.Assertions;
import io.atlassian.fugue.Option;
import javax.annotation.Nonnull;
import org.joda.time.DateTime;

public class NewIfThenExecutionBuilder {
    private final NewRuleExecutionBuilder parent;
    private Long ifThenId;
    private Option<NewIfExecutionBuilder> ifExecutionBuilder;
    private Option<NewThenExecutionBuilder> thenExecutionBuilder;
    private DateTime startTime;
    private DateTime finishTime;
    private Option<String> executedBy;
    private ExecutionResultBuilder<IfThenExecution.Outcome, NewIfThenExecutionBuilder> executionResultBuilder;

    public static NewIfThenExecutionBuilder newBuilder() {
        return new NewIfThenExecutionBuilder();
    }

    private NewIfThenExecutionBuilder() {
        this.parent = null;
        this.ifExecutionBuilder = Option.none();
        this.thenExecutionBuilder = Option.none();
        this.executionResultBuilder = new ExecutionResultBuilder(this);
    }

    NewIfThenExecutionBuilder(NewRuleExecutionBuilder parent) {
        this.parent = parent;
        this.ifExecutionBuilder = Option.none();
        this.thenExecutionBuilder = Option.none();
        this.executionResultBuilder = new ExecutionResultBuilder(this);
    }

    NewIfThenExecutionBuilder(NewRuleExecutionBuilder parent, NewIfThenExecution newIfThenExecution) {
        this.parent = parent;
        this.executionResultBuilder = new ExecutionResultBuilder(this, newIfThenExecution.getResult());
        if (newIfThenExecution.getIfExecution().isEmpty()) {
            this.ifExecutionBuilder = Option.none();
        } else {
            NewIfExecution newIfExecution = (NewIfExecution)newIfThenExecution.getIfExecution().get();
            this.ifExecutionBuilder = Option.some((Object)new NewIfExecutionBuilder(this, newIfExecution));
        }
        if (newIfThenExecution.getThenExecution().isEmpty()) {
            this.thenExecutionBuilder = Option.none();
        } else {
            NewThenExecution newThenExecution = (NewThenExecution)newIfThenExecution.getThenExecution().get();
            this.thenExecutionBuilder = Option.some((Object)new NewThenExecutionBuilder(this, newThenExecution));
        }
        this.ifThenId(newIfThenExecution.getIfThenId());
        this.startTime(newIfThenExecution.getStartTime());
        this.finishTime(newIfThenExecution.getFinishTime());
        this.executedBy(newIfThenExecution.getExecutedBy());
    }

    public NewIfThenExecutionBuilder ifThenId(long theIfThenId) {
        this.ifThenId = theIfThenId;
        return this;
    }

    public NewIfThenExecutionBuilder addIfExecution(@Nonnull NewIfExecution newIfExecution) {
        this.ifExecutionBuilder = Option.some((Object)new NewIfExecutionBuilder(this, newIfExecution));
        return this;
    }

    public NewIfThenExecutionBuilder addThenExecution(@Nonnull NewThenExecution newThenExecution) {
        this.thenExecutionBuilder = Option.some((Object)new NewThenExecutionBuilder(this, newThenExecution));
        return this;
    }

    public NewIfExecutionBuilder ifExecution() {
        NewIfExecutionBuilder ifExecutionBuilder = new NewIfExecutionBuilder(this);
        this.ifExecutionBuilder = Option.some((Object)ifExecutionBuilder);
        return ifExecutionBuilder;
    }

    public NewThenExecutionBuilder thenExecution() {
        NewThenExecutionBuilder thenExecutionBuilder = new NewThenExecutionBuilder(this);
        this.thenExecutionBuilder = Option.some((Object)thenExecutionBuilder);
        return thenExecutionBuilder;
    }

    public NewIfThenExecutionBuilder startTime(DateTime theStartTime) {
        this.startTime = theStartTime;
        return this;
    }

    public NewIfThenExecutionBuilder finishTime(DateTime theFinishTime) {
        this.finishTime = theFinishTime;
        return this;
    }

    public NewIfThenExecutionBuilder executedBy(Option<String> theUserThatExecuted) {
        this.executedBy = theUserThatExecuted;
        return this;
    }

    public ExecutionResultBuilder<IfThenExecution.Outcome, NewIfThenExecutionBuilder> executionResult() {
        return this.executionResultBuilder;
    }

    public NewRuleExecutionBuilder endIfThenExecution() {
        return this.parent;
    }

    public NewIfThenExecution build() {
        this.validate();
        Option ifExecutionOpt = this.ifExecutionBuilder.isDefined() ? Option.option((Object)((NewIfExecutionBuilder)this.ifExecutionBuilder.get()).build()) : Option.none(NewIfExecution.class);
        Option thenExecutionOpt = this.thenExecutionBuilder.isDefined() ? Option.option((Object)((NewThenExecutionBuilder)this.thenExecutionBuilder.get()).build()) : Option.none(NewThenExecution.class);
        return new NewIfThenExecutionImpl(this.ifThenId, (Option<NewIfExecution>)ifExecutionOpt, (Option<NewThenExecution>)thenExecutionOpt, this.startTime, this.finishTime, this.executedBy, this.executionResultBuilder.build());
    }

    private void validate() {
        Assertions.notNull((String)"ifThenId", (Object)this.ifThenId);
        Assertions.notNull((String)"startTime", (Object)this.startTime);
        Assertions.notNull((String)"finishTime", (Object)this.finishTime);
        Assertions.notNull((String)"executedBy", this.executedBy);
    }
}

