/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.builder;

import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewIfConditionExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewIfExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewIfExecutionImpl;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.builder.ExecutionResultBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.builder.NewIfConditionExecutionBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.builder.NewIfThenExecutionBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.IfExecution;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;

public class NewIfExecutionBuilder {
    private final NewIfThenExecutionBuilder parent;
    private List<NewIfConditionExecutionBuilder> ifConditionExecutionBuilders;
    private DateTime startTime;
    private DateTime finishTime;
    private Option<String> executedBy;
    private ExecutionResultBuilder<IfExecution.Outcome, NewIfExecutionBuilder> executionResultBuilder;

    public static NewIfExecutionBuilder newBuilder() {
        return new NewIfExecutionBuilder();
    }

    private NewIfExecutionBuilder() {
        this.parent = null;
        this.ifConditionExecutionBuilders = Lists.newArrayList();
        this.executionResultBuilder = new ExecutionResultBuilder(this);
    }

    @VisibleForTesting
    public NewIfExecutionBuilder(NewIfThenExecutionBuilder parent) {
        this.parent = parent;
        this.ifConditionExecutionBuilders = Lists.newArrayList();
        this.executionResultBuilder = new ExecutionResultBuilder(this);
    }

    NewIfExecutionBuilder(NewIfThenExecutionBuilder parent, NewIfExecution ifExecution) {
        this.parent = parent;
        this.executionResultBuilder = new ExecutionResultBuilder(this, ifExecution.getResult());
        this.startTime = ifExecution.getStartTime();
        this.finishTime = ifExecution.getFinishTime();
        this.executedBy = ifExecution.getExecutedBy();
        this.ifConditionExecutionBuilders = Lists.newArrayList();
        for (NewIfConditionExecution ifConditionExecution : ifExecution.getIfConditionExecutions()) {
            this.ifConditionExecutionBuilders.add(new NewIfConditionExecutionBuilder(this, ifConditionExecution));
        }
    }

    public NewIfConditionExecutionBuilder ifConditionExecution() {
        NewIfConditionExecutionBuilder ifCondExecutionBuilder = new NewIfConditionExecutionBuilder(this);
        this.ifConditionExecutionBuilders.add(ifCondExecutionBuilder);
        return ifCondExecutionBuilder;
    }

    public NewIfExecutionBuilder addIfConditionExecution(NewIfConditionExecution newIfConditionExecution) {
        NewIfConditionExecutionBuilder ifCondExecutionBuilder = new NewIfConditionExecutionBuilder(this, newIfConditionExecution);
        this.ifConditionExecutionBuilders.add(ifCondExecutionBuilder);
        return this;
    }

    public NewIfExecutionBuilder startTime(DateTime theStartTime) {
        this.startTime = theStartTime;
        return this;
    }

    public NewIfExecutionBuilder finishTime(DateTime theFinishTime) {
        this.finishTime = theFinishTime;
        return this;
    }

    public NewIfExecutionBuilder executedBy(Option<String> theUserThatExecuted) {
        this.executedBy = theUserThatExecuted;
        return this;
    }

    public ExecutionResultBuilder<IfExecution.Outcome, NewIfExecutionBuilder> executionResult() {
        return this.executionResultBuilder;
    }

    public NewIfThenExecutionBuilder endIfExecution() {
        return this.parent;
    }

    public NewIfExecution build() {
        this.validate();
        ArrayList ifCondExecutions = Lists.newArrayList();
        for (NewIfConditionExecutionBuilder ifCondExecutionBuilder : this.ifConditionExecutionBuilders) {
            ifCondExecutions.add(ifCondExecutionBuilder.build());
        }
        return new NewIfExecutionImpl(ifCondExecutions, this.startTime, this.finishTime, this.executedBy, this.executionResultBuilder.build());
    }

    private void validate() {
        Assertions.notNull((String)"startTime", (Object)this.startTime);
        Assertions.notNull((String)"finishTime", (Object)this.finishTime);
        Assertions.notNull((String)"executedBy", this.executedBy);
        Assertions.notNull((String)"executionResultBuilder", this.executionResultBuilder);
    }
}

