/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.builder;

import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewIfConditionExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewIfConditionExecutionImpl;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.builder.ExecutionResultBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.builder.NewIfExecutionBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.IfConditionExecution;
import com.atlassian.util.concurrent.Assertions;
import io.atlassian.fugue.Option;
import org.joda.time.DateTime;

public final class NewIfConditionExecutionBuilder {
    private final NewIfExecutionBuilder parent;
    private Long ifConditionId;
    private DateTime startTime;
    private DateTime finishTime;
    private Option<String> executedBy;
    private ExecutionResultBuilder<IfConditionExecution.Outcome, NewIfConditionExecutionBuilder> executionResultBuilder;

    public static NewIfConditionExecutionBuilder newBuilder() {
        return new NewIfConditionExecutionBuilder();
    }

    private NewIfConditionExecutionBuilder() {
        this.parent = null;
        this.executionResultBuilder = new ExecutionResultBuilder(this);
    }

    NewIfConditionExecutionBuilder(NewIfExecutionBuilder parent) {
        this.parent = parent;
        this.executionResultBuilder = new ExecutionResultBuilder(this);
    }

    NewIfConditionExecutionBuilder(NewIfExecutionBuilder parent, NewIfConditionExecution newIfConditionExecution) {
        this.parent = parent;
        this.executionResultBuilder = new ExecutionResultBuilder(this, newIfConditionExecution.getResult());
        this.ifConditionId(newIfConditionExecution.getIfConditionId());
        this.startTime(newIfConditionExecution.getStartTime());
        this.finishTime(newIfConditionExecution.getFinishTime());
        this.executedBy(newIfConditionExecution.getExecutedBy());
    }

    public NewIfConditionExecutionBuilder ifConditionId(long theIfConditionId) {
        this.ifConditionId = theIfConditionId;
        return this;
    }

    public NewIfConditionExecutionBuilder startTime(DateTime theStartTime) {
        this.startTime = theStartTime;
        return this;
    }

    public NewIfConditionExecutionBuilder finishTime(DateTime theFinishTime) {
        this.finishTime = theFinishTime;
        return this;
    }

    public NewIfConditionExecutionBuilder executedBy(Option<String> theUserThatExecuted) {
        this.executedBy = theUserThatExecuted;
        return this;
    }

    public ExecutionResultBuilder<IfConditionExecution.Outcome, NewIfConditionExecutionBuilder> executionResult() {
        return this.executionResultBuilder;
    }

    public NewIfExecutionBuilder endIfConditionExecution() {
        return this.parent;
    }

    public NewIfConditionExecution build() {
        this.validate();
        return new NewIfConditionExecutionImpl(this.ifConditionId, this.startTime, this.finishTime, this.executedBy, this.executionResultBuilder.build());
    }

    private void validate() {
        Assertions.notNull((String)"ifConditionId", (Object)this.ifConditionId);
        Assertions.notNull((String)"startTime", (Object)this.startTime);
        Assertions.notNull((String)"finishTime", (Object)this.finishTime);
        Assertions.notNull((String)"executedBy", this.executedBy);
    }
}

