/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.builder;

import com.atlassian.servicedesk.plugins.automation.internal.execution.history.ExecutionResult;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.ExecutionResultImpl;
import com.atlassian.util.concurrent.Assertions;
import io.atlassian.fugue.Option;

public class ExecutionResultBuilder<O, P> {
    private final P parent;
    private O outcome;
    private Option<String> message;

    ExecutionResultBuilder(P parent) {
        this.parent = parent;
        this.message = Option.none();
    }

    ExecutionResultBuilder(P parent, ExecutionResult<O> result) {
        this.parent = parent;
        this.message = result.getMessage();
        this.outcome = result.getOutcome();
    }

    public ExecutionResultBuilder<O, P> outcome(O theOutcome) {
        this.outcome = theOutcome;
        return this;
    }

    public ExecutionResultBuilder<O, P> message(String theMessage) {
        this.message = Option.option((Object)theMessage);
        return this;
    }

    public P endExecutionResult() {
        return this.parent;
    }

    ExecutionResult<O> build() {
        this.validate();
        return new ExecutionResultImpl<O>(this.outcome, this.message);
    }

    private void validate() {
        Assertions.notNull((String)"outcome", this.outcome);
    }
}

