/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.history.create;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.ozymandias.error.ModuleAccessError;
import com.atlassian.ozymandias.error.ModuleExceptionError;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.Rule;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.RuleImpl;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.ExecutionHistoryManager;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewRuleExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.builder.NewRuleExecutionBuilder;
import com.atlassian.util.concurrent.Assertions;
import javax.annotation.Nonnull;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RulesEngineExecutionHistoryHelper {
    private static final Logger log = LoggerFactory.getLogger(RulesEngineExecutionHistoryHelper.class);
    private final ExecutionHistoryManager executionHistoryManager;

    @Autowired
    public RulesEngineExecutionHistoryHelper(ExecutionHistoryManager executionHistoryManager) {
        this.executionHistoryManager = executionHistoryManager;
    }

    @Nonnull
    public NewRuleExecutionBuilder builderForNewRuleExecution() {
        return NewRuleExecutionBuilder.newBuilder();
    }

    @Nonnull
    public NewRuleExecutionBuilder builderForNewRuleExecution(@Nonnull ApplicationUser executingUser, @Nonnull Rule rule, @Nonnull RuleMessage message) {
        Assertions.notNull((String)"executingUser", (Object)executingUser);
        Assertions.notNull((String)"rule", (Object)rule);
        Assertions.notNull((String)"message", (Object)message);
        NewRuleExecutionBuilder auditEntryBuilder = NewRuleExecutionBuilder.newBuilder();
        long ruleId = ((RuleImpl)rule).getId();
        return auditEntryBuilder.ruleId(ruleId).ruleMessage(message).startTime(DateTime.now()).executedBy(executingUser.getKey());
    }

    public void saveExecutionHistory(NewRuleExecution toSave) {
        this.executionHistoryManager.record(toSave);
    }

    @Nonnull
    public String getErrorMessageForModuleAccessError(@Nonnull String moduleKey, @Nonnull ModuleAccessError moduleAccessError) {
        Assertions.notNull((String)"moduleKey", (Object)moduleKey);
        Assertions.notNull((String)"moduleAccessError", (Object)moduleAccessError);
        String errorMessage = "Error while accessing module with module key: " + moduleKey + "\n" + moduleAccessError.getErrorMessage();
        if (moduleAccessError.getClass() == ModuleExceptionError.class) {
            ModuleExceptionError moduleExceptionError = (ModuleExceptionError)moduleAccessError;
            String fullStackTrace = ExceptionUtils.getFullStackTrace((Throwable)moduleExceptionError.getException());
            errorMessage = errorMessage + "\n" + fullStackTrace;
        }
        return errorMessage;
    }
}

