/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.history;

import com.atlassian.fugue.Either;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.ExecutionHistoryFilter;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.ExecutionHistoryManager;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewRuleExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.dao.ExecutionHistoryDao;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.RuleExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.RuleExecutionSummary;
import com.atlassian.util.concurrent.Assertions;
import io.atlassian.fugue.Option;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExecutionHistoryManagerImpl
implements ExecutionHistoryManager {
    private static long MAX_EXECUTION_RETRIEVAL_LIMIT = 100L;
    private final ExecutionHistoryDao executionHistoryDao;
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    public ExecutionHistoryManagerImpl(ExecutionHistoryDao executionHistoryDao, ErrorResultHelper errorResultHelper) {
        this.executionHistoryDao = executionHistoryDao;
        this.errorResultHelper = errorResultHelper;
    }

    @Override
    public void record(@Nonnull NewRuleExecution aRuleExecution) {
        Assertions.notNull((String)"aRuleExecution", (Object)aRuleExecution);
        this.executionHistoryDao.create(aRuleExecution);
    }

    @Override
    @Nonnull
    public List<RuleExecutionSummary> getExecutionsForRule(@Nonnull Long ruleSetId, ExecutionHistoryFilter filter) {
        return this.executionHistoryDao.getByRuleSetId(ruleSetId, MAX_EXECUTION_RETRIEVAL_LIMIT, filter);
    }

    @Override
    @Nonnull
    public List<String> getIssueKeysForRuleExecutions(@Nonnull Long ruleSetId, String issueKeySearchPattern) {
        return this.executionHistoryDao.getIssueKeysByRuleSetId(ruleSetId, issueKeySearchPattern);
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<AnError, RuleExecution> getExecutionDetails(@Nonnull Long ruleExecutionId) {
        Option<RuleExecution> ruleExecutionOpt = this.executionHistoryDao.get(ruleExecutionId);
        if (ruleExecutionOpt.isEmpty()) {
            return StepsConverters.newerEither((Either)this.errorResultHelper.error(HttpStatusCode.NOT_FOUND, "sd.automation.rule.execution.not.found", new Object[]{ruleExecutionId}));
        }
        return io.atlassian.fugue.Either.right((Object)ruleExecutionOpt.get());
    }
}

