/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.engine.vertigo;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.issue.Issue;
import com.atlassian.psmq.api.QSession;
import com.atlassian.psmq.api.QSessionDefinition;
import com.atlassian.psmq.api.QSessionDefinitionBuilder;
import com.atlassian.psmq.api.QSessionFactory;
import com.atlassian.psmq.api.message.QMessage;
import com.atlassian.psmq.api.queue.Queue;
import com.atlassian.psmq.api.queue.QueueDefinition;
import com.atlassian.psmq.api.queue.QueueDefinitionBuilder;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.IssueMessageHelper;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.job.ExecutionJob;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.vertigo.ExecutionJobConverter;
import com.atlassian.servicedesk.plugins.automation.internal.execution.rule.InternalRuleReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class VertigoExecutionJobEnqueuer {
    private static final Logger log = LoggerFactory.getLogger(VertigoExecutionJobEnqueuer.class);
    private static final String QUEUE_PREFIX = "com.atlassian.servicedesk.plugins.automation.executor.queue";
    private static final QueueDefinition GENERIC_QUEUE_DEFINITION = QueueDefinitionBuilder.newDefinition().withName("com.atlassian.servicedesk.plugins.automation.executor.queue.generic").build();
    private static final QSessionDefinition QUEUE_WRITER_SESSION = QSessionDefinitionBuilder.newDefinition().withAutoCommitStrategy().build();
    private final IssueMessageHelper issueMessageHelper;
    private final QSessionFactory qSessionFactory;
    private final ExecutionJobConverter executionJobConverter;

    @Autowired
    public VertigoExecutionJobEnqueuer(IssueMessageHelper issueMessageHelper, QSessionFactory qSessionFactory, ExecutionJobConverter executionJobConverter) {
        this.issueMessageHelper = issueMessageHelper;
        this.qSessionFactory = qSessionFactory;
        this.executionJobConverter = executionJobConverter;
    }

    public Set<String> add(List<ExecutionJob> jobs) {
        if (jobs.isEmpty()) {
            return Collections.emptySet();
        }
        try (QSession session = this.qSessionFactory.createSession(QUEUE_WRITER_SESSION);){
            HashSet<String> queueNames = new HashSet<String>();
            for (ExecutionJob job : jobs) {
                String queueName = this.addJob(session, job);
                queueNames.add(queueName);
            }
            HashSet<String> hashSet = queueNames;
            return hashSet;
        }
    }

    private String addJob(QSession session, ExecutionJob job) {
        Queue queue = this.getQueue(session, job);
        QMessage jobMessage = this.executionJobConverter.toQMessage(job);
        session.createProducer(queue).writeMessage(jobMessage);
        session.queueOperations().releaseQueue(queue);
        this.logQueueOperationDetails(job, queue);
        return queue.name();
    }

    private void logQueueOperationDetails(ExecutionJob job, Queue queue) {
        InternalRuleReference rr = job.getStack().getCurrentRuleReference();
        log.debug("Adding execution for rule with ruleSetId '{}',  ruleSetRevisionId '{}', ruleId '{}' on queue '{}'", new Object[]{rr.getRuleSetId(), rr.getRuleSetRevisionId(), rr.getRuleId(), queue.name()});
    }

    private Queue getQueue(QSession session, ExecutionJob job) {
        RuleMessage ruleMessage = job.getRuleMessage();
        QueueDefinition queueDef = (QueueDefinition)this.issueMessageHelper.getIssue(ruleMessage).fold(e -> GENERIC_QUEUE_DEFINITION, this::getQueueForIssue);
        return session.queueOperations().accessQueue(queueDef);
    }

    private QueueDefinition getQueueForIssue(Issue issue) {
        String issueQueueName = "com.atlassian.servicedesk.plugins.automation.executor.queue.issue." + issue.getKey();
        return QueueDefinitionBuilder.newDefinition().withName(issueQueueName).build();
    }
}

