/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.engine.vertigo;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.psmq.api.message.QMessage;
import com.atlassian.psmq.api.message.QMessageBuilder;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilderService;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.job.ExecutionJob;
import com.atlassian.servicedesk.plugins.automation.internal.execution.rule.InternalRuleReference;
import com.atlassian.servicedesk.plugins.automation.internal.execution.rule.RuleReferenceImpl;
import com.atlassian.servicedesk.plugins.automation.internal.execution.rule.RuleReferenceStack;
import com.google.gson.Gson;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class ExecutionJobConverter {
    private static final Gson GSON = new Gson();
    private final RuleMessageBuilderService ruleMessageBuilderService;

    @Autowired
    public ExecutionJobConverter(RuleMessageBuilderService ruleMessageBuilderService) {
        this.ruleMessageBuilderService = ruleMessageBuilderService;
    }

    public QMessage toQMessage(ExecutionJob job) {
        QMessageBuilder builder = QMessageBuilder.newMsg();
        String serializedExecutionJob = GSON.toJson((Object)new ExecutionJobEnvelope(job.getRuleMessage(), this.encodeRuleReferenceStack(job.getStack())));
        builder.newBuffer().append(serializedExecutionJob).build();
        return builder.build();
    }

    private String encodeRuleReferenceStack(RuleReferenceStack stack) {
        StringBuilder bld = new StringBuilder();
        for (InternalRuleReference rr : stack.getStack()) {
            bld.append(rr.getRuleSetId());
            bld.append("-");
            bld.append(rr.getRuleSetRevisionId());
            bld.append("-");
            bld.append(rr.getRuleId());
            bld.append("-");
        }
        return bld.toString();
    }

    public ExecutionJob fromQMessage(QMessage qMessage) {
        ExecutionJobEnvelope envelope = (ExecutionJobEnvelope)GSON.fromJson(qMessage.buffer().asString(), ExecutionJobEnvelope.class);
        RuleMessage ruleMessage = this.ruleMessageBuilderService.builder().putAllValues(envelope.ruleMessage).build();
        RuleReferenceStack ruleStack = this.decodeRuleReferenceStack(envelope.stack);
        return new ExecutionJob(ruleMessage, ruleStack);
    }

    private RuleReferenceStack decodeRuleReferenceStack(String encodedStack) {
        StringTokenizer st = new StringTokenizer(encodedStack, "-");
        LinkedList<InternalRuleReference> ruleReferenceList = new LinkedList<InternalRuleReference>();
        while (st.hasMoreTokens()) {
            RuleReferenceImpl rr = new RuleReferenceImpl(Long.valueOf(st.nextToken()), Long.valueOf(st.nextToken()), Long.valueOf(st.nextToken()));
            ruleReferenceList.add(rr);
        }
        return new RuleReferenceStack(ruleReferenceList);
    }

    private static class ExecutionJobEnvelope {
        public final Map<String, String> ruleMessage;
        public final String stack;

        public ExecutionJobEnvelope(RuleMessage ruleMessage, String stack) {
            this.ruleMessage = ruleMessage.getAllValues();
            this.stack = stack;
        }
    }
}

