/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.engine.sync;

import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.async.AsynchronousExecutionJobRunner;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.job.ExecutionJob;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.process.ExecutionJobProcessor;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.sync.SynchronousExecutionJobRunner;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.sync.ThreadLocalExecutionJobQueue;
import io.atlassian.fugue.Option;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SynchronousExecutionJobRunnerImpl
implements SynchronousExecutionJobRunner {
    private static final Logger LOG = LoggerFactory.getLogger(SynchronousExecutionJobRunnerImpl.class);
    private final ThreadLocalExecutionJobQueue threadLocalExecutionJobQueue;
    private final AsynchronousExecutionJobRunner asynchronousExecutionJobRunner;
    private final ExecutionJobProcessor executionJobProcessor;
    private ThreadLocal<Option<Object>> perThreadExecutionLock = new ThreadLocal<Option<Object>>(){

        @Override
        protected Option<Object> initialValue() {
            return Option.none();
        }
    };

    @Autowired
    public SynchronousExecutionJobRunnerImpl(ThreadLocalExecutionJobQueue threadLocalExecutionJobQueue, AsynchronousExecutionJobRunner asynchronousExecutionJobRunner, ExecutionJobProcessor executionJobProcessor) {
        this.threadLocalExecutionJobQueue = threadLocalExecutionJobQueue;
        this.asynchronousExecutionJobRunner = asynchronousExecutionJobRunner;
        this.executionJobProcessor = executionJobProcessor;
    }

    @Override
    public void executeJobs() {
        LOG.debug("attempting to acquire perThreadExecutionLock.");
        if (this.perThreadExecutionLock.get().isEmpty()) {
            try {
                this.perThreadExecutionLock.set((Option<Object>)Option.some((Object)this));
                LOG.debug("perThreadExecutionLock acquired.");
                this.executeJobsImpl();
            }
            finally {
                this.perThreadExecutionLock.remove();
                LOG.debug("perThreadExecutionLock released.");
            }
        }
    }

    public void executeJobsImpl() {
        boolean continueExecution = true;
        while (continueExecution) {
            continueExecution = this.executeNextJob();
        }
        Queue<ExecutionJob> asynchronousExecutionJobs = this.threadLocalExecutionJobQueue.getAsynchronousExecutionJobQueueAndClear();
        this.asynchronousExecutionJobRunner.enqueueJobs(asynchronousExecutionJobs);
    }

    private boolean executeNextJob() {
        Option<ExecutionJob> synchronousJob = this.threadLocalExecutionJobQueue.popSynchronousExecutionJob();
        if (synchronousJob.isDefined()) {
            this.executionJobProcessor.processJob((ExecutionJob)synchronousJob.get());
            return true;
        }
        return false;
    }
}

