/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.engine.process;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.ozymandias.error.ModuleAccessError;
import com.atlassian.pocketknife.api.commons.error.ErrorMessage;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.If;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.IfConditionConfiguration;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.IfConditionError;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.ComponentConfigurationImpl;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.process.RuleMatcherResult;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewIfConditionExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewIfExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.RulesEngineExecutionHistoryHelper;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.builder.NewIfConditionExecutionBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.builder.NewIfExecutionBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.IfConditionExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.IfExecution;
import com.atlassian.servicedesk.plugins.automation.internal.module.IfConditionManager;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class RuleMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(RuleMatcher.class);
    private final IfConditionManager ifConditionManager;
    private final RulesEngineExecutionHistoryHelper rulesEngineExecutionHistoryHelper;

    @Autowired
    public RuleMatcher(IfConditionManager ifConditionManager, RulesEngineExecutionHistoryHelper rulesEngineExecutionHistoryHelper) {
        this.rulesEngineExecutionHistoryHelper = rulesEngineExecutionHistoryHelper;
        this.ifConditionManager = ifConditionManager;
    }

    RuleMatcherResult match(@Nonnull RuleMessage ruleMessage, @Nonnull If anIf, @Nonnull ApplicationUser user) {
        Assertions.notNull((String)"ruleMessage", (Object)ruleMessage);
        Assertions.notNull((String)"anIf", (Object)anIf);
        Assertions.notNull((String)"user", (Object)user);
        NewIfExecutionBuilder newIfExecutionBuilder = this.startIfAuditEntry(user);
        List ifConditionConfigurations = anIf.getIfConditionConfigurations();
        if (ifConditionConfigurations.isEmpty()) {
            NewIfExecution newIfExecution = this.endIfAuditEntryWithNoIfConditions(newIfExecutionBuilder);
            return new RuleMatcherResult(newIfExecution);
        }
        ArrayList newIfConditionExecutions = Lists.newArrayList();
        for (IfConditionConfiguration configuration : ifConditionConfigurations) {
            NewIfConditionExecution newIfConditionExecution = this.evaluateIfCondition(user, configuration, ruleMessage);
            newIfConditionExecutions.add(newIfConditionExecution);
            IfConditionExecution.Outcome outcome = (IfConditionExecution.Outcome)((Object)newIfConditionExecution.getResult().getOutcome());
            if (outcome != IfConditionExecution.Outcome.ERROR && outcome != IfConditionExecution.Outcome.NOT_MET) continue;
            break;
        }
        NewIfExecution newIfExecution = this.endIfAuditEntryWithOutcome(newIfExecutionBuilder, newIfConditionExecutions);
        return new RuleMatcherResult(newIfExecution);
    }

    private NewIfConditionExecution evaluateIfCondition(ApplicationUser user, IfConditionConfiguration configuration, RuleMessage ruleMessage) {
        NewIfConditionExecutionBuilder ifCondAuditEntryBuilder = this.startIfCondAuditEntry(configuration, user);
        Either<? extends ModuleAccessError, Either<IfConditionError, Boolean>> resultEither = this.ifConditionManager.evaluateIfCondition(user, configuration, ruleMessage);
        if (resultEither.isLeft()) {
            String moduleKey = configuration.getModuleKey();
            LOG.debug("A rule matcher condition with module key '{}' could not be evaluated for the following config data: {}", (Object)moduleKey, (Object)configuration.getData().getAll());
            return this.endIfCondAuditEntryWithModuleAccessError(ifCondAuditEntryBuilder, moduleKey, (ModuleAccessError)resultEither.left().get());
        }
        Either evaluationResult = (Either)resultEither.right().get();
        if (evaluationResult.isLeft()) {
            IfConditionError ifConditionError = (IfConditionError)evaluationResult.left().get();
            ErrorMessage errorMessage = ifConditionError.getMessage();
            String message = errorMessage.getMessage();
            return this.endIfCondAuditEntryWithError(ifCondAuditEntryBuilder, message);
        }
        Boolean matches = (Boolean)evaluationResult.right().get();
        if (!matches.booleanValue()) {
            LOG.debug("A rule matcher condition with module key '{}' did not match for the following config data: {}", (Object)configuration.getModuleKey(), (Object)configuration.getData().getAll());
            return this.endIfCondAuditEntryWithNoMatch(ifCondAuditEntryBuilder);
        }
        return this.endIfCondAuditEntryWithMatch(ifCondAuditEntryBuilder);
    }

    private NewIfExecutionBuilder startIfAuditEntry(ApplicationUser user) {
        return NewIfExecutionBuilder.newBuilder().startTime(DateTime.now()).executedBy((Option<String>)Option.some((Object)user.getKey()));
    }

    private NewIfExecution endIfAuditEntryWithOutcome(NewIfExecutionBuilder ifExecutionBuilder, List<NewIfConditionExecution> newIfConditionExecutions) {
        IfExecution.Outcome outcome = IfExecution.Outcome.ALL_CONDITIONS_MET;
        for (NewIfConditionExecution newIfConditionExecution : newIfConditionExecutions) {
            IfConditionExecution.Outcome result = (IfConditionExecution.Outcome)((Object)newIfConditionExecution.getResult().getOutcome());
            if (result == IfConditionExecution.Outcome.ERROR) {
                outcome = IfExecution.Outcome.ERROR;
                break;
            }
            if (result != IfConditionExecution.Outcome.NOT_MET) continue;
            outcome = IfExecution.Outcome.NOT_ALL_CONDITIONS_MET;
        }
        for (NewIfConditionExecution newIfConditionExecution : newIfConditionExecutions) {
            ifExecutionBuilder.addIfConditionExecution(newIfConditionExecution);
        }
        NewIfExecutionBuilder newIfExecutionBuilder = ifExecutionBuilder.finishTime(DateTime.now()).executionResult().outcome(outcome).endExecutionResult();
        return newIfExecutionBuilder.build();
    }

    private NewIfConditionExecution endIfCondAuditEntryWithMatch(NewIfConditionExecutionBuilder ifCondAuditEntryBuilder) {
        NewIfConditionExecutionBuilder newIfConditionExecutionBuilder = ifCondAuditEntryBuilder.finishTime(DateTime.now()).executionResult().outcome(IfConditionExecution.Outcome.MET).endExecutionResult();
        return newIfConditionExecutionBuilder.build();
    }

    private NewIfConditionExecution endIfCondAuditEntryWithNoMatch(NewIfConditionExecutionBuilder ifCondAuditEntryBuilder) {
        NewIfConditionExecutionBuilder newIfConditionExecutionBuilder = ifCondAuditEntryBuilder.finishTime(DateTime.now()).executionResult().outcome(IfConditionExecution.Outcome.NOT_MET).endExecutionResult();
        return newIfConditionExecutionBuilder.build();
    }

    private NewIfConditionExecution endIfCondAuditEntryWithModuleAccessError(NewIfConditionExecutionBuilder ifCondAuditEntryBuilder, String moduleKey, ModuleAccessError moduleAccessError) {
        String errorMessageForModuleAccessError = this.rulesEngineExecutionHistoryHelper.getErrorMessageForModuleAccessError(moduleKey, moduleAccessError);
        return this.endIfCondAuditEntryWithError(ifCondAuditEntryBuilder, errorMessageForModuleAccessError);
    }

    private NewIfConditionExecution endIfCondAuditEntryWithError(NewIfConditionExecutionBuilder ifCondAuditEntryBuilder, String errorMessage) {
        NewIfConditionExecutionBuilder newIfConditionExecutionBuilder = ifCondAuditEntryBuilder.finishTime(DateTime.now()).executionResult().outcome(IfConditionExecution.Outcome.ERROR).message(errorMessage).endExecutionResult();
        return newIfConditionExecutionBuilder.build();
    }

    private NewIfConditionExecutionBuilder startIfCondAuditEntry(IfConditionConfiguration ifConditionConfiguration, ApplicationUser executingUser) {
        long ifConditionId = ((ComponentConfigurationImpl)ifConditionConfiguration).getId();
        return NewIfConditionExecutionBuilder.newBuilder().ifConditionId(ifConditionId).startTime(DateTime.now()).executedBy((Option<String>)Option.some((Object)executingUser.getKey()));
    }

    private NewIfExecution endIfAuditEntryWithNoIfConditions(NewIfExecutionBuilder auditEntryBuilder) {
        NewIfExecutionBuilder newIfExecutionBuilder = auditEntryBuilder.finishTime(DateTime.now()).executionResult().outcome(IfExecution.Outcome.ALL_CONDITIONS_MET).message("No if conditions").endExecutionResult();
        return newIfExecutionBuilder.build();
    }
}

