/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.engine.process;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.ozymandias.error.ModuleAccessError;
import com.atlassian.pocketknife.api.commons.error.ErrorMessage;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.Then;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ThenActionConfiguration;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionError;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.ComponentConfigurationImpl;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.process.RuleActionResult;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewThenActionExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.NewThenExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.RulesEngineExecutionHistoryHelper;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.builder.NewThenActionExecutionBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.builder.NewThenExecutionBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.ThenActionExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.ThenExecution;
import com.atlassian.servicedesk.plugins.automation.internal.module.ThenActionManager;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class RuleActionInvoker {
    private static final Logger LOG = LoggerFactory.getLogger(RuleActionInvoker.class);
    private final ThenActionManager thenActionManager;
    private final RulesEngineExecutionHistoryHelper rulesEngineExecutionHistoryHelper;

    @Autowired
    public RuleActionInvoker(ThenActionManager thenActionManager, RulesEngineExecutionHistoryHelper rulesEngineExecutionHistoryHelper) {
        this.rulesEngineExecutionHistoryHelper = rulesEngineExecutionHistoryHelper;
        this.thenActionManager = thenActionManager;
    }

    RuleActionResult invokeActions(@Nonnull RuleMessage ruleMessage, @Nonnull Then then, @Nonnull ApplicationUser user) {
        Assertions.notNull((String)"ruleMessage is required", (Object)ruleMessage);
        Assertions.notNull((String)"then is required", (Object)then);
        Assertions.notNull((String)"ruleContext is user", (Object)user);
        NewThenExecutionBuilder newThenExecutionBuilder = this.startThenAuditEntry(user);
        List thenActionConfigurationList = then.getThenActionConfigurations();
        RuleMessage currentRuleMessage = ruleMessage;
        ArrayList newThenActionExecutions = Lists.newArrayList();
        for (ThenActionConfiguration thenActionConfiguration : thenActionConfigurationList) {
            currentRuleMessage = this.executeThenAction(user, thenActionConfiguration, currentRuleMessage, newThenActionExecutions);
        }
        NewThenExecution newThenExecution = this.endThenAuditWithActionsInvoked(newThenExecutionBuilder, newThenActionExecutions);
        return new RuleActionResult(newThenExecution);
    }

    private RuleMessage executeThenAction(ApplicationUser user, ThenActionConfiguration thenActionConfiguration, RuleMessage ruleMessage, List<NewThenActionExecution> newThenActionExecutions) {
        NewThenActionExecutionBuilder thenActionAuditEntryBuilder = this.startThenActionAuditEntry(thenActionConfiguration, user.getKey());
        Either<? extends ModuleAccessError, Either<ThenActionError, RuleMessage>> ruleMessageEither = this.thenActionManager.executeThenAction(user, thenActionConfiguration, ruleMessage);
        if (ruleMessageEither.isLeft()) {
            String moduleKey = thenActionConfiguration.getModuleKey();
            LOG.debug("An error was thrown when invoking action with module key '{}' for the following config data: {}", (Object)moduleKey, (Object)thenActionConfiguration.getData().getAll());
            NewThenActionExecution newThenActionExecution = this.endThenActionAuditEntryWithModuleAccessError(thenActionAuditEntryBuilder, moduleKey, (ModuleAccessError)ruleMessageEither.left().get());
            newThenActionExecutions.add(newThenActionExecution);
            return ruleMessage;
        }
        Either executionResult = (Either)ruleMessageEither.right().get();
        if (executionResult.isLeft()) {
            ErrorMessage errorMessage = ((ThenActionError)executionResult.left().get()).getMessage();
            String message = errorMessage.getMessage();
            NewThenActionExecution newThenActionExecution = this.endThenActionAuditEntryWithError(thenActionAuditEntryBuilder, message);
            newThenActionExecutions.add(newThenActionExecution);
            return ruleMessage;
        }
        RuleMessage newRuleMessage = (RuleMessage)executionResult.right().get();
        LOG.debug("Invoking action with module key {} was invoked successfully and returned rule message: {}", (Object)thenActionConfiguration.getModuleKey(), (Object)newRuleMessage);
        NewThenActionExecution newThenActionExecution = this.endThenActionAuditEntryWithSuccess(thenActionAuditEntryBuilder);
        newThenActionExecutions.add(newThenActionExecution);
        return newRuleMessage;
    }

    private NewThenExecutionBuilder startThenAuditEntry(ApplicationUser user) {
        return NewThenExecutionBuilder.newBuilder().startTime(DateTime.now()).executedBy((Option<String>)Option.some((Object)user.getKey()));
    }

    private NewThenActionExecutionBuilder startThenActionAuditEntry(ThenActionConfiguration thenActionConfiguration, String executingUser) {
        long thenActionId = ((ComponentConfigurationImpl)thenActionConfiguration).getId();
        return NewThenActionExecutionBuilder.newBuilder().thenActionId(thenActionId).startTime(DateTime.now()).executedBy((Option<String>)Option.some((Object)executingUser));
    }

    private NewThenActionExecution endThenActionAuditEntryWithModuleAccessError(NewThenActionExecutionBuilder thenActionAuditEntryBuilder, String moduleKey, ModuleAccessError moduleAccessError) {
        String errorMessageForModuleAccessError = this.rulesEngineExecutionHistoryHelper.getErrorMessageForModuleAccessError(moduleKey, moduleAccessError);
        return this.endThenActionAuditEntryWithError(thenActionAuditEntryBuilder, errorMessageForModuleAccessError);
    }

    private NewThenActionExecution endThenActionAuditEntryWithError(NewThenActionExecutionBuilder thenActionAuditEntryBuilder, String message) {
        NewThenActionExecutionBuilder newThenActionExecutionBuilder = thenActionAuditEntryBuilder.finishTime(DateTime.now()).executionResult().outcome(ThenActionExecution.Outcome.ERROR).message(message).endExecutionResult();
        return newThenActionExecutionBuilder.build();
    }

    private NewThenActionExecution endThenActionAuditEntryWithSuccess(NewThenActionExecutionBuilder thenActionAuditEntryBuilder) {
        NewThenActionExecutionBuilder newThenActionExecutionBuilder = thenActionAuditEntryBuilder.finishTime(DateTime.now()).executionResult().outcome(ThenActionExecution.Outcome.SUCCESS).endExecutionResult();
        return newThenActionExecutionBuilder.build();
    }

    private NewThenExecution endThenAuditWithActionsInvoked(NewThenExecutionBuilder auditEntryBuilder, List<NewThenActionExecution> newThenActionExecutions) {
        ThenExecution.Outcome outcome = ThenExecution.Outcome.ALL_ACTIONS_INVOKED;
        for (NewThenActionExecution newThenActionExecution : newThenActionExecutions) {
            if (!((ThenActionExecution.Outcome)((Object)newThenActionExecution.getResult().getOutcome())).equals((Object)ThenActionExecution.Outcome.ERROR)) continue;
            outcome = ThenExecution.Outcome.SOME_ACTIONS_INVOKED;
            break;
        }
        for (NewThenActionExecution newThenActionExecution : newThenActionExecutions) {
            auditEntryBuilder.addThenActionExecution(newThenActionExecution);
        }
        NewThenExecutionBuilder newThenExecutionBuilder = auditEntryBuilder.finishTime(DateTime.now()).executionResult().outcome(outcome).endExecutionResult();
        return newThenExecutionBuilder.build();
    }
}

