/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.engine.process;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.Rule;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSet;
import com.atlassian.servicedesk.plugins.automation.api.execution.context.user.InContextVisitor;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.RuleSetManager;
import com.atlassian.servicedesk.plugins.automation.internal.execution.context.user.RunAsUserContext;
import com.atlassian.servicedesk.plugins.automation.internal.execution.context.user.RunAsUserContextManager;
import com.atlassian.servicedesk.plugins.automation.internal.execution.context.user.RunAsUserService;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.job.ExecutionJob;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.param.RuleExecutionParamImpl;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.process.ExecutionJobProcessor;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.process.RuleProcessor;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.process.RuleProcessorRunAsCurrentUserProvider;
import com.atlassian.servicedesk.plugins.automation.internal.execution.rule.RuleAndRuleSet;
import com.atlassian.servicedesk.plugins.automation.internal.module.RuleExecutionInterceptorManager;
import com.atlassian.util.concurrent.Assertions;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExecutionJobProcessorImpl
implements ExecutionJobProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutionJobProcessorImpl.class);
    private final RuleSetManager ruleSetManager;
    private final RunAsUserService runAsUserService;
    private final RunAsUserContextManager runAsUserContextManager;
    private final RuleProcessorRunAsCurrentUserProvider ruleProcessorRunAsCurrentUserProvider;
    private final RuleProcessor ruleProcessor;
    private final RuleExecutionInterceptorManager ruleExecutionInterceptorManager;
    ThreadLocal<Option<ExecutionJob>> executingJob = new ThreadLocal<Option<ExecutionJob>>(){

        @Override
        protected Option<ExecutionJob> initialValue() {
            return Option.none();
        }
    };

    @Autowired
    public ExecutionJobProcessorImpl(RuleSetManager ruleSetManager, RunAsUserContextManager runAsUserContextManager, RunAsUserService runAsUserService, RuleProcessorRunAsCurrentUserProvider ruleProcessorRunAsCurrentUserProvider, RuleProcessor ruleProcessor, RuleExecutionInterceptorManager ruleExecutionInterceptorManager) {
        this.ruleSetManager = ruleSetManager;
        this.runAsUserService = runAsUserService;
        this.runAsUserContextManager = runAsUserContextManager;
        this.ruleProcessorRunAsCurrentUserProvider = ruleProcessorRunAsCurrentUserProvider;
        this.ruleProcessor = ruleProcessor;
        this.ruleExecutionInterceptorManager = ruleExecutionInterceptorManager;
    }

    @Override
    public void processJob(ExecutionJob executionJob) {
        Assertions.notNull((String)"executionJob", (Object)executionJob);
        Option<ExecutionJob> outerExecutingJob = this.executingJob.get();
        try {
            this.executingJob.set((Option<ExecutionJob>)Option.some((Object)executionJob));
            this.processJobImpl(executionJob);
        }
        finally {
            this.executingJob.set(outerExecutingJob);
        }
    }

    @Override
    public Option<ExecutionJob> getExecutingJob() {
        return this.executingJob.get();
    }

    private void processJobImpl(@Nonnull ExecutionJob executionJob) {
        RunAsUserContextManager.CurrentUserProvider currentUserProvider;
        Either<AnError, RuleAndRuleSet> ruleAndRuleSetResult = this.ruleSetManager.loadRuleReference(executionJob.getStack().getCurrentRuleReference());
        if (ruleAndRuleSetResult.isLeft()) {
            LOG.warn("Cannot run rule, failed to load rule and rule set: {}", (Object)((AnError)ruleAndRuleSetResult.left().get()).getMessage().getMessage());
            return;
        }
        RuleAndRuleSet ruleAndRuleSet = (RuleAndRuleSet)ruleAndRuleSetResult.right().get();
        RuleSet ruleSet = ruleAndRuleSet.getRuleSet();
        if (this.ruleHasBeenTriggeredFromAnotherRule(executionJob) && !ruleSet.getTriggerFromOtherRules()) {
            LOG.debug("Rule execution suppressed for rule '{}', as it has been triggered via another rule.", (Object)ruleSet.getName());
            return;
        }
        RuleMessage ruleMessage = executionJob.getRuleMessage();
        Either<AnError, RunAsUserContext> userContextResult = this.runAsUserContextManager.getApplicableContextForRule(ruleSet);
        if (userContextResult.isLeft()) {
            LOG.warn("Cannot run rule, user context invalid: {} (message = {})", (Object)((AnError)userContextResult.left().get()).getMessage().getMessage(), (Object)ruleMessage);
            return;
        }
        RunAsUserContext runAsUserContext = (RunAsUserContext)userContextResult.right().get();
        Either<AnError, Option<ApplicationUser>> userFromContext = this.runAsUserContextManager.getUserFromContext(runAsUserContext, currentUserProvider = this.ruleProcessorRunAsCurrentUserProvider.forMessage(ruleMessage));
        if (userFromContext.isLeft()) {
            LOG.warn("Cannot run rule, user for specified user context invalid: {} (message = {})", (Object)((AnError)userFromContext.left().get()).getMessage().getMessage(), (Object)ruleMessage);
            return;
        }
        ApplicationUser runAsUser = (ApplicationUser)((Option)userFromContext.right().get()).getOrNull();
        Rule rule = ruleAndRuleSet.getRule();
        this.processInUserContext(runAsUser, ruleMessage, rule);
    }

    private boolean ruleHasBeenTriggeredFromAnotherRule(ExecutionJob executionJob) {
        return executionJob.getStack().getDepth() > 1;
    }

    void processInUserContext(@Nonnull ApplicationUser runAsUser, final @Nonnull RuleMessage ruleMessage, final @Nonnull Rule rule) {
        Assertions.notNull((String)"ruleMessage is required", (Object)ruleMessage);
        Assertions.notNull((String)"rule is required", (Object)rule);
        this.runAsUserService.runAsUser(runAsUser, new InContextVisitor(){

            public void run(ApplicationUser user) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Executing rule with the '{}' user with the following rule message: {}", (Object)(user != null ? user.getUsername() : ""), (Object)ruleMessage);
                    ExecutionJobProcessorImpl.this.logSchedulerState();
                }
                ExecutionJobProcessorImpl.this.processWithInterceptors(user, ruleMessage, rule);
            }
        });
    }

    void processWithInterceptors(@Nonnull ApplicationUser user, @Nonnull RuleMessage ruleMessage, @Nonnull Rule rule) {
        RuleExecutionParamImpl executionParam = new RuleExecutionParamImpl(user, ruleMessage, rule);
        this.ruleExecutionInterceptorManager.runInterceptors(executionParam, this.ruleProcessor);
    }

    private void logSchedulerState() {
        SchedulerService schedulerService = (SchedulerService)ComponentAccessor.getComponent(SchedulerService.class);
        if (schedulerService == null) {
            return;
        }
        Set jobRunners = schedulerService.getJobRunnerKeysForAllScheduledJobs();
        long numJobs = jobRunners.stream().flatMap(jobRunnerKey -> schedulerService.getJobsByJobRunnerKey(jobRunnerKey).stream()).collect(Collectors.toList()).size();
        LOG.debug("Atlassian Scheduler state: {} jobs runners and {} jobs.", (Object)jobRunners.size(), (Object)numJobs);
    }
}

