/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.engine.job;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.plugins.automation.api.execution.command.RuleExecutionCommand;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.job.ExecutionJob;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.job.ExecutionJobCreatorImpl;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.job.ExecutionJobManager;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.sync.SynchronousExecutionJobRunner;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.sync.ThreadLocalExecutionJobQueue;
import io.atlassian.fugue.Either;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LegacyExecutionJobManager
implements ExecutionJobManager {
    private final ExecutionJobCreatorImpl executionJobCreator;
    private final ThreadLocalExecutionJobQueue threadLocalExecutionJobQueue;
    private final SynchronousExecutionJobRunner synchronousExecutionJobRunner;

    @Autowired
    public LegacyExecutionJobManager(ExecutionJobCreatorImpl executionJobCreator, ThreadLocalExecutionJobQueue threadLocalExecutionJobQueue, SynchronousExecutionJobRunner synchronousExecutionJobRunner) {
        this.executionJobCreator = executionJobCreator;
        this.threadLocalExecutionJobQueue = threadLocalExecutionJobQueue;
        this.synchronousExecutionJobRunner = synchronousExecutionJobRunner;
    }

    @Override
    public Either<AnError, ExecutionJob> createJob(RuleExecutionCommand command) {
        return this.executionJobCreator.createJob(command);
    }

    @Override
    public void registerJobs(@Nonnull List<ExecutionJob> jobs) {
        if (!jobs.isEmpty()) {
            this.threadLocalExecutionJobQueue.enqueueJobsInThread(jobs);
        }
    }

    @Override
    public void executeJobs() {
        this.synchronousExecutionJobRunner.executeJobs();
    }
}

