/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.engine.job;

import com.atlassian.fugue.Either;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.execution.command.RuleExecutionCommand;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilder;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilderService;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.RuleSetMessageHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.rule.RuleReference;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.job.ExecutionJob;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.job.ExecutionJobCreator;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.process.ExecutionJobProcessor;
import com.atlassian.servicedesk.plugins.automation.internal.execution.rule.InternalRuleReference;
import com.atlassian.servicedesk.plugins.automation.internal.execution.rule.RuleReferenceImpl;
import com.atlassian.servicedesk.plugins.automation.internal.execution.rule.RuleReferenceStack;
import com.atlassian.servicedesk.plugins.automation.internal.module.RuleExecutionPreprocessorManager;
import com.atlassian.util.concurrent.Assertions;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExecutionJobCreatorImpl
implements ExecutionJobCreator {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutionJobCreatorImpl.class);
    private static final int MAX_STACK_DEPTH = 10;
    private static final int MAX_RULE_OCCURRENCE_IN_STACK = 1;
    private final ExecutionJobProcessor executionJobProcessor;
    private final ErrorResultHelper errorHelper;
    private final RuleExecutionPreprocessorManager ruleExecutionPreprocessorManager;
    private final RuleMessageBuilderService ruleMessageBuilderService;
    private final RuleSetMessageHelper ruleSetMessageHelper;

    @Autowired
    public ExecutionJobCreatorImpl(ExecutionJobProcessor executionJobProcessor, ErrorResultHelper errorHelper, RuleExecutionPreprocessorManager ruleExecutionPreprocessorManager, RuleMessageBuilderService ruleMessageBuilderService, RuleSetMessageHelper ruleSetMessageHelper) {
        this.executionJobProcessor = executionJobProcessor;
        this.errorHelper = errorHelper;
        this.ruleExecutionPreprocessorManager = ruleExecutionPreprocessorManager;
        this.ruleMessageBuilderService = ruleMessageBuilderService;
        this.ruleSetMessageHelper = ruleSetMessageHelper;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, ExecutionJob> createJob(RuleExecutionCommand command) {
        RuleReferenceStack stack;
        Assertions.notNull((String)"command", (Object)command);
        RuleMessage ruleMessage = this.ruleMessageWithRuleSetId(command.getRuleMessage(), command.getRuleReference());
        io.atlassian.fugue.Either<AnError, RuleMessage> processedRuleMessageResult = this.ruleExecutionPreprocessorManager.preprocess(ruleMessage);
        if (processedRuleMessageResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)processedRuleMessageResult.left().get());
        }
        RuleMessage processedRuleMessage = (RuleMessage)processedRuleMessageResult.right().get();
        io.atlassian.fugue.Either<AnError, Unit> sanityCheck = this.stackSanityChecks(processedRuleMessage, stack = this.createStack(command.getRuleReference()));
        if (sanityCheck.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)sanityCheck.left().get());
        }
        return io.atlassian.fugue.Either.right((Object)new ExecutionJob(processedRuleMessage, stack));
    }

    private RuleMessage ruleMessageWithRuleSetId(RuleMessage ruleMessage, RuleReference ruleReference) {
        Long ruleSetId = ((InternalRuleReference)ruleReference).getRuleSetId();
        RuleMessageBuilder builder = this.ruleMessageBuilderService.builder(ruleMessage);
        this.ruleSetMessageHelper.setRuleSetId(builder, ruleSetId);
        return builder.build();
    }

    private RuleReferenceStack createStack(RuleReference ruleReference) {
        InternalRuleReference internalRuleReference = (InternalRuleReference)ruleReference;
        RuleReferenceImpl bareRuleReference = new RuleReferenceImpl(internalRuleReference.getRuleSetId(), internalRuleReference.getRuleSetRevisionId(), internalRuleReference.getRuleId());
        Option<ExecutionJob> job = this.executionJobProcessor.getExecutingJob();
        if (job.isDefined()) {
            return ((ExecutionJob)job.get()).getStack().withRuleReference(bareRuleReference);
        }
        return new RuleReferenceStack(bareRuleReference);
    }

    private io.atlassian.fugue.Either<AnError, Unit> stackSanityChecks(RuleMessage ruleMessage, RuleReferenceStack stack) {
        if (stack.getDepth() > 10) {
            LOG.warn("Job depth exceeded. Dropping message: {} for rule {}", (Object)ruleMessage, (Object)stack.getCurrentRuleReference());
            return StepsConverters.newerEither((Either)this.errorHelper.error(HttpStatusCode.BAD_REQUEST, "sd.automation.error.job.dropped.max.depth.exceeded", new Object[0]));
        }
        InternalRuleReference ruleReference = stack.getCurrentRuleReference();
        if (stack.countOccurrences(ruleReference) > 1) {
            LOG.warn("Rule detected multiple times in rule execution stack. Dropping message: {} for rule {}", (Object)ruleMessage, (Object)stack.getCurrentRuleReference());
            return StepsConverters.newerEither((Either)this.errorHelper.error(HttpStatusCode.BAD_REQUEST, "sd.automation.error.job.dropped.loop.detected", new Object[0]));
        }
        return io.atlassian.fugue.Either.right((Object)Unit.Unit());
    }
}

