/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.engine.asyncthen.vertigo;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.pocketknife.amq.api.fastfive.FastFiveManaged;
import com.atlassian.pocketknife.amq.api.offthread.OffThreadAccessor;
import com.atlassian.pocketknife.amq.api.offthread.OffThreadMethodRunner;
import com.atlassian.psmq.api.QSession;
import com.atlassian.psmq.api.QSessionDefinition;
import com.atlassian.psmq.api.QSessionDefinitionBuilder;
import com.atlassian.psmq.api.QSessionFactory;
import com.atlassian.psmq.api.message.QMessage;
import com.atlassian.psmq.api.message.QMessageConsumer;
import com.atlassian.psmq.api.message.QMessageProducer;
import com.atlassian.psmq.api.queue.Queue;
import com.atlassian.psmq.api.queue.QueueDefinition;
import com.atlassian.psmq.api.queue.QueueDefinitionBuilder;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionError;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.asyncthen.AsyncThenCommand;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.asyncthen.AsyncThenExecutor;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.asyncthen.AsyncThenJobProcessor;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.asyncthen.vertigo.AsyncThenCommandQMessageConverter;
import io.atlassian.fugue.Either;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class VertigoAsyncThenExecutor
implements AsyncThenExecutor,
OffThreadMethodRunner {
    private static final Logger log = LoggerFactory.getLogger(VertigoAsyncThenExecutor.class);
    private static final QueueDefinition ASYNC_THEN_QUEUE_DEFINITION = QueueDefinitionBuilder.newDefinition().withName("com.atlassian.servicedesk.plugins.automation.asyncthen.queue").build();
    private static final QSessionDefinition ASYNC_THEN_SESSION_DEFINITION = QSessionDefinitionBuilder.newDefinition().withAutoCommitStrategy().build();
    private final OffThreadAccessor offThreadAccessor;
    private final QSessionFactory qSessionFactory;
    private final AsyncThenCommandQMessageConverter asyncThenCommandConverter;
    private final AsyncThenJobProcessor asyncThenJobProcessor;

    @Autowired
    public VertigoAsyncThenExecutor(OffThreadAccessor offThreadAccessor, QSessionFactory qSessionFactory, AsyncThenCommandQMessageConverter asyncThenCommandConverter, AsyncThenJobProcessor asyncThenJobProcessor) {
        this.offThreadAccessor = offThreadAccessor;
        this.qSessionFactory = qSessionFactory;
        this.asyncThenCommandConverter = asyncThenCommandConverter;
        this.asyncThenJobProcessor = asyncThenJobProcessor;
    }

    @PostConstruct
    private void postConstruct() {
        this.offThreadAccessor.registerOffThreadMethodRunner((OffThreadMethodRunner)this);
    }

    @Override
    public Either<ThenActionError, RuleMessage> run(AsyncThenCommand command) {
        QMessage cmdMessage = this.asyncThenCommandConverter.toQMessage(command);
        this.enqueueMessage(cmdMessage);
        ((VertigoAsyncThenExecutor)this.offThreadAccessor.runOffThread((OffThreadMethodRunner)this)).executeAsyncThen();
        return Either.right((Object)command.getThenActionParam().getMessage());
    }

    private void enqueueMessage(QMessage message) {
        try (QSession session = this.qSessionFactory.createSession(ASYNC_THEN_SESSION_DEFINITION);){
            Queue queue = session.queueOperations().accessQueue(ASYNC_THEN_QUEUE_DEFINITION);
            QMessageProducer producer = session.createProducer(queue);
            producer.writeMessage(message);
            producer.close();
            session.queueOperations().releaseQueue(queue);
        }
    }

    @FastFiveManaged
    protected void executeAsyncThen() {
        try (QSession session = this.qSessionFactory.createSession(ASYNC_THEN_SESSION_DEFINITION);){
            Queue queue = session.queueOperations().accessQueue(ASYNC_THEN_QUEUE_DEFINITION);
            QMessageConsumer consumer = session.createConsumer(queue);
            consumer.claimAndResolve().ifPresent(this::execute);
            consumer.close();
            session.queueOperations().releaseQueue(queue);
        }
    }

    private void execute(QMessage qMessage) {
        Either<ThenActionError, AsyncThenCommand> convertResult = this.asyncThenCommandConverter.fromQMessage(qMessage);
        if (convertResult.isLeft()) {
            log.error("Unable to execute automation async then for qmessage with contents {}; {}", (Object)qMessage.buffer().asString(), (Object)((ThenActionError)convertResult.left().get()).getMessage().getMessage());
        } else {
            convertResult.forEach(this.asyncThenJobProcessor::run);
        }
    }
}

