/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.engine.asyncthen.vertigo;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.pocketknife.api.commons.error.ErrorMessage;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.psmq.api.message.QMessage;
import com.atlassian.psmq.api.message.QMessageBuilder;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ThenActionConfiguration;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionError;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilderService;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.ConfigurationDataImpl;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.asyncthen.AsyncThenCommand;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.asyncthen.vertigo.ThenActionRetriever;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.param.ThenActionParamImpl;
import com.atlassian.servicedesk.plugins.automation.spi.rulethen.ThenAction;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.LongSerializationPolicy;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
final class AsyncThenCommandQMessageConverter {
    private static final Gson GSON = AsyncThenCommandQMessageConverter.longAsStringsGsonInstance();
    private final ThenActionRetriever thenActionRetriever;
    private final UserManager userManager;
    private final RuleMessageBuilderService ruleMessageBuilderService;

    private static Gson longAsStringsGsonInstance() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setLongSerializationPolicy(LongSerializationPolicy.STRING);
        return gsonBuilder.create();
    }

    @Autowired
    AsyncThenCommandQMessageConverter(ThenActionRetriever thenActionRetriever, UserManager userManager, RuleMessageBuilderService ruleMessageBuilderService) {
        this.thenActionRetriever = thenActionRetriever;
        this.userManager = userManager;
        this.ruleMessageBuilderService = ruleMessageBuilderService;
    }

    QMessage toQMessage(AsyncThenCommand thenCommand) {
        Assertions.notNull((String)"thenCommand", (Object)thenCommand);
        String serializedThenCommand = this.serialize(thenCommand);
        QMessageBuilder builder = QMessageBuilder.newMsg();
        builder.newBuffer().append(serializedThenCommand).build();
        return builder.build();
    }

    private String serialize(AsyncThenCommand thenCommand) {
        ThenAction.ThenActionParam toSerialize = thenCommand.getThenActionParam();
        return GSON.toJson((Object)new AsyncThenCommandEnvelope(toSerialize.getConfiguration().getModuleKey(), toSerialize.getUser().getId(), toSerialize.getConfiguration().getData().getAll(), toSerialize.getMessage().getAllValues()));
    }

    Either<ThenActionError, AsyncThenCommand> fromQMessage(QMessage message) {
        Assertions.notNull((String)"message", (Object)message);
        AsyncThenCommandEnvelope deserialized = this.deserialize(message);
        return Steps.begin((Either)this.thenActionRetriever.retrieve(deserialized.moduleKey).toRight(() -> this.missingThenActionModuleError(deserialized.moduleKey))).then(thenAction -> Option.fromOptional((Optional)this.userManager.getUserById(Long.valueOf(deserialized.userId))).toRight(() -> this.missingUserError(deserialized.userId))).yield((thenAction, user) -> this.createThenCommand((ThenAction)thenAction, (ApplicationUser)user, deserialized));
    }

    private AsyncThenCommandEnvelope deserialize(QMessage message) {
        return (AsyncThenCommandEnvelope)GSON.fromJson(message.buffer().asString(), AsyncThenCommandEnvelope.class);
    }

    private ThenActionError missingThenActionModuleError(String missingModuleKey) {
        ErrorMessage errorMessage = ErrorMessage.builder().message(String.format("Unable to execute async then action; then action module with key '%s' could not be found", missingModuleKey)).build();
        return new ThenActionError(errorMessage, 500);
    }

    private ThenActionError missingUserError(long missingUserId) {
        ErrorMessage errorMessage = ErrorMessage.builder().message(String.format("Unable to execute async then action; user with id '%d' could not be found", missingUserId)).build();
        return new ThenActionError(errorMessage, 500);
    }

    private AsyncThenCommand createThenCommand(ThenAction thenAction, ApplicationUser user, AsyncThenCommandEnvelope otherDeserailizedValues) {
        return new AsyncThenCommand(thenAction, new ThenActionParamImpl(user, new DeserializedThenActionConfiguration(otherDeserailizedValues.moduleKey, otherDeserailizedValues.configData), this.createRuleMessage(otherDeserailizedValues.ruleMessageData)));
    }

    private RuleMessage createRuleMessage(Map<String, String> ruleMessageData) {
        return this.ruleMessageBuilderService.builder().putAllValues(ruleMessageData).build();
    }

    private static class DeserializedThenActionConfiguration
    implements ThenActionConfiguration {
        private final String moduleKey;
        private final ConfigurationData configData;

        private DeserializedThenActionConfiguration(String moduleKey, Map<String, String> configData) {
            this.moduleKey = moduleKey;
            this.configData = new ConfigurationDataImpl((Map<String, String>)ImmutableMap.copyOf(configData));
        }

        public String getModuleKey() {
            return this.moduleKey;
        }

        @Nonnull
        public ConfigurationData getData() {
            return this.configData;
        }
    }

    private static class AsyncThenCommandEnvelope {
        public final String moduleKey;
        public final long userId;
        public final Map<String, String> configData;
        public final Map<String, String> ruleMessageData;

        private AsyncThenCommandEnvelope(String moduleKey, long userId, Map<String, String> configData, Map<String, String> ruleMessageData) {
            this.moduleKey = moduleKey;
            this.userId = userId;
            this.configData = configData;
            this.ruleMessageData = ruleMessageData;
        }
    }
}

