/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.engine.asyncthen.legacy;

import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.asyncthen.AsyncThenCommand;
import com.atlassian.util.concurrent.Assertions;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LegacyAsyncThenJobQueue {
    private static final Logger log = LoggerFactory.getLogger(LegacyAsyncThenJobQueue.class);
    private final Queue<AsyncThenCommand> queue = new ConcurrentLinkedQueue<AsyncThenCommand>();

    public void enqueue(@Nonnull AsyncThenCommand command) {
        Assertions.notNull((String)"command", (Object)command);
        this.queue.add(command);
        log.debug("Enqueued " + command);
    }

    public void remove(@Nonnull AsyncThenCommand command) {
        Assertions.notNull((String)"command", (Object)command);
        log.debug("Removing " + command);
        this.queue.remove(command);
    }

    @Nullable
    public AsyncThenCommand poll() {
        AsyncThenCommand command = this.queue.poll();
        log.debug("Polling " + command);
        return command;
    }
}

