/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.engine.asyncthen;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.fugue.Either;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.execution.error.ThenActionError;
import com.atlassian.servicedesk.plugins.automation.internal.execution.context.user.RunAsUserService;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.asyncthen.AsyncThenCommand;
import com.atlassian.servicedesk.plugins.automation.spi.rulethen.ThenAction;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class AsyncThenJobProcessor {
    private static final Logger log = LoggerFactory.getLogger(AsyncThenJobProcessor.class);
    private final RunAsUserService runAsUserService;

    @Autowired
    public AsyncThenJobProcessor(RunAsUserService runAsUserService) {
        this.runAsUserService = runAsUserService;
    }

    public void run(AsyncThenCommand thenCommand) {
        ThenAction thenAction = thenCommand.getThenAction();
        ThenAction.ThenActionParam thenActionParam = thenCommand.getThenActionParam();
        ApplicationUser user = thenActionParam.getUser();
        this.runAsUserService.runAsUser(user, u -> {
            log.debug("Running {} as user {}", (Object)thenAction.getClass().getName(), (Object)user.getName());
            io.atlassian.fugue.Either result = StepsConverters.newerEither((Either)thenAction.invoke(thenActionParam));
            if (result.isRight()) {
                log.info("Execution of Asynchronous ThenAction {} is successful", (Object)thenAction.getClass().getName());
            } else {
                log.warn("Failed executing ThenAction {} asynchronously: {}", (Object)thenAction.getClass().getName(), (Object)((ThenActionError)result.left().get()).getMessage());
            }
        });
    }
}

