/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.engine.async;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.async.AsynchronousExecutionJobExecutor;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.async.AsynchronousExecutionThreadManager;
import com.atlassian.util.concurrent.Assertions;
import java.util.Date;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AsynchronousExecutionThreadManagerImpl
implements AsynchronousExecutionThreadManager {
    private static final JobRunnerKey EXECUTOR_JOB_RUNNER_KEY = JobRunnerKey.of((String)"com.atlassian.servicedesk.plugins.automation.internal.execution.engine.async.AsynchronousExecutionJobExecutor");
    private static final JobId EXECUTOR_JOB_ID = JobId.of((String)"com.atlassian.servicedesk.plugins.automation.internal.execution.engine.async.AsynchronousExecutionJobExecutor");
    private final SchedulerService schedulerService;
    final AsynchronousExecutionJobExecutor asynchronousExecutionJobExecutor;

    @Autowired
    public AsynchronousExecutionThreadManagerImpl(SchedulerService schedulerService, AsynchronousExecutionJobExecutor asynchronousExecutionJobExecutor) {
        this.schedulerService = schedulerService;
        this.asynchronousExecutionJobExecutor = asynchronousExecutionJobExecutor;
    }

    @Override
    public void register() {
        this.schedulerService.registerJobRunner(EXECUTOR_JOB_RUNNER_KEY, (JobRunner)new ServiceDeskAutomationAsynchronousRuleExecutionJobRunner(this.asynchronousExecutionJobExecutor));
    }

    @Override
    public void unregister() {
        this.schedulerService.unregisterJobRunner(EXECUTOR_JOB_RUNNER_KEY);
    }

    @Override
    public void executeQueuedJobs() {
        this.startRunner();
    }

    private synchronized void startRunner() {
        try {
            this.schedulerService.scheduleJob(EXECUTOR_JOB_ID, this.jobConfigRunOnceLocallyNow(EXECUTOR_JOB_RUNNER_KEY, 0L));
        }
        catch (SchedulerServiceException e) {
            throw new RuntimeException("Unable to schedule asynchronous rule execution job", e);
        }
    }

    private JobConfig jobConfigRunOnceLocallyNow(JobRunnerKey jobRunnerKey, long executionDelay) {
        return JobConfig.forJobRunnerKey((JobRunnerKey)jobRunnerKey).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.runOnce((Date)new Date(System.currentTimeMillis() + executionDelay)));
    }

    private static class ServiceDeskAutomationAsynchronousRuleExecutionJobRunner
    implements JobRunner {
        private final AsynchronousExecutionJobExecutor executor;

        private ServiceDeskAutomationAsynchronousRuleExecutionJobRunner(AsynchronousExecutionJobExecutor executor) {
            Assertions.notNull((String)"executor", (Object)executor);
            this.executor = executor;
        }

        @Nullable
        public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
            try {
                this.executor.execute();
                return JobRunnerResponse.success();
            }
            catch (Exception e) {
                return JobRunnerResponse.failed((Throwable)e);
            }
        }
    }
}

