/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.engine;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.plugins.automation.api.execution.command.RuleExecutionCommand;
import com.atlassian.servicedesk.plugins.automation.api.execution.engine.RulesEngine;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.job.DelegatorExecutionJobManager;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.job.ExecutionJob;
import com.atlassian.servicedesk.plugins.automation.internal.execution.engine.job.ExecutionJobManager;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.RulesEngineExecutionHistoryHelper;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.create.builder.NewRuleExecutionBuilder;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.retrieve.RuleExecution;
import com.atlassian.servicedesk.plugins.automation.internal.execution.rule.InternalRuleReference;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public final class RulesEngineImpl
implements RulesEngine {
    private static final Logger LOG = LoggerFactory.getLogger(RulesEngineImpl.class);
    private final ExecutionJobManager executionJobManager;
    private final RulesEngineExecutionHistoryHelper executionHistoryHelper;

    @Autowired
    public RulesEngineImpl(DelegatorExecutionJobManager executionJobManager, RulesEngineExecutionHistoryHelper executionHistoryHelper) {
        this.executionJobManager = executionJobManager;
        this.executionHistoryHelper = executionHistoryHelper;
    }

    public void enqueue(List<RuleExecutionCommand> commands) {
        Assertions.notNull((String)"commands", commands);
        LOG.debug("{} commands enqueued for execution.", (Object)commands.size());
        ArrayList jobs = Lists.newArrayList();
        for (RuleExecutionCommand command : commands) {
            Either<AnError, ExecutionJob> job = this.executionJobManager.createJob(command);
            if (job.isRight()) {
                jobs.add(job.right().get());
                continue;
            }
            this.recordPreprocessFailed(command, (AnError)job.left().get());
        }
        if (jobs.isEmpty()) {
            return;
        }
        this.executionJobManager.registerJobs(jobs);
        this.executionJobManager.executeJobs();
    }

    private void recordPreprocessFailed(RuleExecutionCommand command, AnError theError) {
        NewRuleExecutionBuilder ruleExecutionBuilder = this.executionHistoryHelper.builderForNewRuleExecution();
        InternalRuleReference ruleReference = (InternalRuleReference)command.getRuleReference();
        DateTime startAndFinishTime = DateTime.now();
        ruleExecutionBuilder.ruleId(ruleReference.getRuleId()).startTime(startAndFinishTime).finishTime(startAndFinishTime).executionResult().outcome(RuleExecution.Outcome.ERROR).message(theError.getMessage().getMessage()).endExecutionResult();
        this.executionHistoryHelper.saveExecutionHistory(ruleExecutionBuilder.build());
    }
}

