/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.context.user;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.plugins.automation.api.execution.context.user.InContextFunction;
import com.atlassian.servicedesk.plugins.automation.api.execution.context.user.InContextVisitor;
import com.atlassian.servicedesk.plugins.automation.internal.execution.context.user.RunAsUserService;
import com.atlassian.util.concurrent.Assertions;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RunAsUserServiceImpl
implements RunAsUserService {
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Autowired
    public RunAsUserServiceImpl(@Nonnull JiraAuthenticationContext jiraAuthenticationContext) {
        Assertions.notNull((String)"jiraAuthenticationContext", (Object)jiraAuthenticationContext);
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T runAsUser(ApplicationUser user, InContextFunction<T> callback) {
        ApplicationUser currentUser = this.jiraAuthenticationContext.getLoggedInUser();
        try {
            this.jiraAuthenticationContext.setLoggedInUser(user);
            Object object = callback.run(user);
            return (T)object;
        }
        finally {
            this.jiraAuthenticationContext.setLoggedInUser(currentUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runAsUser(ApplicationUser user, InContextVisitor callback) {
        ApplicationUser currentUser = this.jiraAuthenticationContext.getLoggedInUser();
        try {
            this.jiraAuthenticationContext.setLoggedInUser(user);
            callback.run(user);
        }
        finally {
            this.jiraAuthenticationContext.setLoggedInUser(currentUser);
        }
    }
}

