/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.execution.context.user;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.api.commons.result.ServiceResult;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSet;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RuleSetRunAsUserContextConfigService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RunAsCurrentUserContextConfig;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RunAsSpecificUserContextConfig;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RunAsUserContextConfig;
import com.atlassian.servicedesk.plugins.automation.api.execution.context.project.ProjectContext;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.project.InternalRuleSetProjectContextConfigService;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.project.ProjectRunAsUserContextConfigManager;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.user.RunAsCurrentUserContextConfigImpl;
import com.atlassian.servicedesk.plugins.automation.internal.execution.context.user.RunAsCurrentUserContext;
import com.atlassian.servicedesk.plugins.automation.internal.execution.context.user.RunAsCurrentUserContextImpl;
import com.atlassian.servicedesk.plugins.automation.internal.execution.context.user.RunAsSpecificUserContext;
import com.atlassian.servicedesk.plugins.automation.internal.execution.context.user.RunAsSpecificUserContextImpl;
import com.atlassian.servicedesk.plugins.automation.internal.execution.context.user.RunAsUserContext;
import com.atlassian.servicedesk.plugins.automation.internal.execution.context.user.RunAsUserContextManager;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RunAsUserContextManagerImpl
implements RunAsUserContextManager {
    private static final Logger LOG = LoggerFactory.getLogger(RunAsUserContextManagerImpl.class);
    private static final RunAsUserContextConfig SYSTEM_DEFAULT_USER_CONTEXT = new RunAsCurrentUserContextConfigImpl();
    private final RuleSetRunAsUserContextConfigService ruleSetRunAsUserContextConfigService;
    private final InternalRuleSetProjectContextConfigService projectContextService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ErrorResultHelper errorHelper;
    private final ProjectRunAsUserContextConfigManager projectRunAsUserContextConfigManager;
    private final UserManager userManager;

    @Autowired
    public RunAsUserContextManagerImpl(@Nonnull RuleSetRunAsUserContextConfigService ruleSetRunAsUserContextConfigService, @Nonnull InternalRuleSetProjectContextConfigService projectContextService, @Nonnull JiraAuthenticationContext jiraAuthenticationContext, @Nonnull ErrorResultHelper errorHelper, @Nonnull ProjectRunAsUserContextConfigManager projectRunAsUserContextConfigManager, @Nonnull UserManager userManager) {
        this.projectRunAsUserContextConfigManager = projectRunAsUserContextConfigManager;
        this.userManager = userManager;
        this.ruleSetRunAsUserContextConfigService = ruleSetRunAsUserContextConfigService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.errorHelper = errorHelper;
        this.projectContextService = projectContextService;
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<AnError, RunAsUserContext> getApplicableContextForRule(@Nonnull RuleSet ruleSet) {
        io.atlassian.fugue.Either<AnError, RunAsUserContextConfig> applicableContextConfigForRule = this.getApplicableContextConfigForRule(ruleSet);
        if (applicableContextConfigForRule.isLeft()) {
            return StepsConverters.newerEither((Either)ServiceResult.error((AnError)((AnError)applicableContextConfigForRule.left().get())));
        }
        return this.convertConfigToContext((RunAsUserContextConfig)applicableContextConfigForRule.right().get());
    }

    @Nonnull
    io.atlassian.fugue.Either<AnError, RunAsUserContextConfig> getApplicableContextConfigForRule(@Nonnull RuleSet ruleSet) {
        io.atlassian.fugue.Either contextForRuleSetEither = StepsConverters.newerEither((Either)this.ruleSetRunAsUserContextConfigService.getRunAsUserContextConfigForRuleSet(ruleSet)).map(StepsConverters::newerOption);
        if (contextForRuleSetEither.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)contextForRuleSetEither.left().get());
        }
        Option contextConfigForRuleSet = (Option)contextForRuleSetEither.right().get();
        if (contextConfigForRuleSet.isDefined()) {
            return io.atlassian.fugue.Either.right((Object)contextConfigForRuleSet.get());
        }
        io.atlassian.fugue.Either<AnError, ProjectContext> projectContextForRuleSetEither = this.projectContextService.getProjectContext(ruleSet);
        if (projectContextForRuleSetEither.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)projectContextForRuleSetEither.left().get());
        }
        ProjectContext projectContext = (ProjectContext)projectContextForRuleSetEither.right().get();
        List projects = projectContext.getProjects();
        if (!projects.isEmpty()) {
            ArrayList forProjects = Lists.newArrayList();
            for (Project project : projects) {
                io.atlassian.fugue.Either<AnError, Option<RunAsUserContextConfig>> runAsUserContextForProjectEither = this.projectRunAsUserContextConfigManager.getContextConfigForProject(project);
                if (runAsUserContextForProjectEither.isLeft()) {
                    return io.atlassian.fugue.Either.left((Object)runAsUserContextForProjectEither.left().get());
                }
                forProjects.add(runAsUserContextForProjectEither.right().get());
            }
            Iterator iterator = forProjects.iterator();
            Option firstConfig = (Option)iterator.next();
            while (iterator.hasNext()) {
                boolean notTheSame;
                Option otherConfig = (Option)iterator.next();
                if (firstConfig.isEmpty() && otherConfig.isEmpty() || !(notTheSame = firstConfig.isEmpty() || firstConfig.isDefined() && otherConfig.isEmpty() || !((RunAsUserContextConfig)firstConfig.get()).equals(otherConfig.get()))) continue;
                LOG.warn("RuleSet defines multiple projects for its scope, but user contexts don't match for all of them");
                return StepsConverters.newerEither((Either)this.errorHelper.error(HttpStatusCode.BAD_REQUEST, "user.context.mismatch", new Object[0]));
            }
            if (firstConfig.isDefined()) {
                RunAsUserContextConfig right = (RunAsUserContextConfig)firstConfig.get();
                return io.atlassian.fugue.Either.right((Object)right);
            }
        }
        return io.atlassian.fugue.Either.right((Object)SYSTEM_DEFAULT_USER_CONTEXT);
    }

    @Nonnull
    io.atlassian.fugue.Either<AnError, RunAsUserContext> convertConfigToContext(@Nonnull RunAsUserContextConfig runAsUserContextConfig) {
        Assertions.notNull((String)"runAsUserContextConfig", (Object)runAsUserContextConfig);
        Class<?> runAsUserContextConfigClass = runAsUserContextConfig.getClass();
        if (RunAsCurrentUserContextConfig.class.isAssignableFrom(runAsUserContextConfigClass)) {
            RunAsCurrentUserContextImpl runAsCurrentUserContext = new RunAsCurrentUserContextImpl();
            return io.atlassian.fugue.Either.right((Object)runAsCurrentUserContext);
        }
        if (RunAsSpecificUserContextConfig.class.isAssignableFrom(runAsUserContextConfigClass)) {
            String userKey = ((RunAsSpecificUserContextConfig)runAsUserContextConfig).getUserKey();
            ApplicationUser userByKey = this.userManager.getUserByKey(userKey);
            if (userByKey == null) {
                return StepsConverters.newerEither((Either)this.errorHelper.error(HttpStatusCode.NOT_FOUND, "user.not.found", new Object[0]));
            }
            RunAsSpecificUserContextImpl runAsSpecificUserContext = new RunAsSpecificUserContextImpl(userByKey);
            return io.atlassian.fugue.Either.right((Object)runAsSpecificUserContext);
        }
        return StepsConverters.newerEither((Either)this.errorHelper.error(HttpStatusCode.NOT_FOUND, "class.not.supported", new Object[0]));
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<AnError, Option<ApplicationUser>> getUserFromContext(RunAsUserContext runAsUserContext, RunAsUserContextManager.CurrentUserProvider currentUserProvider) {
        Assertions.notNull((String)"runAsUserContext", (Object)runAsUserContext);
        Assertions.notNull((String)"currentUserProvider", (Object)currentUserProvider);
        if (RunAsCurrentUserContext.class.isAssignableFrom(runAsUserContext.getClass())) {
            return currentUserProvider.getCurrentUser();
        }
        if (RunAsSpecificUserContext.class.isAssignableFrom(runAsUserContext.getClass())) {
            ApplicationUser applicationUser = ((RunAsSpecificUserContext)runAsUserContext).getUser();
            return io.atlassian.fugue.Either.right((Object)Option.some((Object)applicationUser));
        }
        LOG.warn("This type of RunAsUserContext is not supported");
        return StepsConverters.newerEither((Either)this.errorHelper.error(HttpStatusCode.NOT_FOUND, "user.not.found", new Object[0]));
    }
}

