/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.descriptors.condition;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.WebFragmentHelper;
import com.atlassian.plugin.web.conditions.ConditionLoadingException;
import com.atlassian.plugin.web.descriptors.ConditionElementParser;
import com.atlassian.servicedesk.plugins.automation.internal.descriptors.condition.ConditionDescriptorFactory;
import javax.annotation.Nonnull;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConditionDescriptorFactoryImpl
implements ConditionDescriptorFactory,
ConditionElementParser.ConditionFactory {
    private ConditionElementParser conditionElementParser = new ConditionElementParser((ConditionElementParser.ConditionFactory)this);
    private WebFragmentHelper webFragmentHelper;

    @Autowired
    public ConditionDescriptorFactoryImpl(WebFragmentHelper webFragmentHelper) {
        this.webFragmentHelper = webFragmentHelper;
    }

    public Condition create(String className, Plugin plugin) throws ConditionLoadingException {
        return this.webFragmentHelper.loadCondition(className, plugin);
    }

    @Override
    @Nonnull
    public Condition retrieveCondition(@Nonnull Plugin plugin, @Nonnull Element element) {
        Element conditionEl = element.element("condition");
        Element conditionsEl = element.element("conditions");
        if (conditionEl != null || conditionsEl != null) {
            if (conditionEl != null && conditionEl.attribute("class") == null) {
                throw new PluginParseException("class is a required attribute of the condition tag; plugin module: " + plugin.getKey());
            }
            if (conditionsEl != null && !conditionsEl.selectNodes("./condition[not(@class)]").isEmpty()) {
                throw new PluginParseException("class is a required attribute of the conditions tag; plugin module: " + plugin.getKey());
            }
            return this.conditionElementParser.makeConditions(plugin, element, 1);
        }
        return DEFAULT_CONDITION;
    }
}

