/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.descriptors.condition;

import com.atlassian.fugue.Option;
import com.atlassian.ozymandias.PluginPointFunction;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.descriptors.ConditionalDescriptor;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;

public abstract class ConditionAwarePluginPointFunction<D extends ModuleDescriptor<MT> & ConditionalDescriptor, MT, RT>
implements PluginPointFunction<D, MT, RT> {
    public final RT onModule(D moduleDescriptor, MT module) {
        if (this.shouldDisplay(moduleDescriptor)) {
            return this.onModuleShouldDisplay(moduleDescriptor, module);
        }
        return this.onModuleShouldNotDisplay(moduleDescriptor, module);
    }

    protected abstract RT onModuleShouldDisplay(D var1, MT var2);

    protected abstract RT onModuleShouldNotDisplay(D var1, MT var2);

    protected Map<String, Object> getConditionContext() {
        return Maps.newHashMap();
    }

    private boolean shouldDisplay(@Nonnull D moduleDescriptor) {
        Option conditionOption = Option.option((Object)((ConditionalDescriptor)moduleDescriptor).getCondition());
        if (conditionOption.isEmpty()) {
            return true;
        }
        Condition condition = (Condition)conditionOption.get();
        Map<String, Object> context = this.getConditionContext();
        return condition.shouldDisplay(context);
    }
}

