/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.descriptors;

import com.atlassian.fugue.Option;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.servicedesk.plugins.automation.internal.descriptors.AbstractRuleComponentModuleDescriptor;
import com.atlassian.servicedesk.plugins.automation.internal.descriptors.condition.ConditionDescriptorFactory;
import com.atlassian.servicedesk.plugins.automation.internal.spi.descriptors.WhenHandlerModuleDescriptor;
import com.atlassian.servicedesk.plugins.automation.spi.rulewhen.WhenHandlerValidator;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class WhenHandlerModuleDescriptorImpl
extends AbstractRuleComponentModuleDescriptor<String, WhenHandlerValidator>
implements WhenHandlerModuleDescriptor {
    private static final Logger log = LoggerFactory.getLogger(WhenHandlerModuleDescriptorImpl.class);
    private ImmutableSet<String> provides;
    private boolean unique = false;

    @Autowired
    public WhenHandlerModuleDescriptorImpl(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory, ConditionDescriptorFactory conditionDescriptorFactory) {
        super(authenticationContext, moduleFactory, conditionDescriptorFactory);
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.unique = (Boolean)Option.option((Object)element.attribute("unique")).map(Attribute::getValue).map(Boolean::parseBoolean).getOrElse((Object)false);
        HashSet mutableProvideList = Sets.newHashSet();
        Option providesElementOption = Option.option((Object)element.element("provides"));
        if (providesElementOption.isDefined()) {
            Element providesElement = (Element)providesElementOption.get();
            Iterator provideListIterator = providesElement.elementIterator("provide");
            while (provideListIterator.hasNext()) {
                Object provideElement = provideListIterator.next();
                if (provideElement != null && provideElement instanceof Element) {
                    String provide = ((Element)provideElement).getText();
                    if (provide != null && StringUtils.isNotBlank((String)provide.trim())) {
                        mutableProvideList.add(provide.toLowerCase().trim());
                        continue;
                    }
                    log.debug("A 'provide' element is empty for " + this.getCompleteKey());
                    continue;
                }
                log.debug("A 'provide' element is invalid " + this.getCompleteKey());
            }
        } else {
            log.debug("No 'provides' element provided for " + this.getCompleteKey());
        }
        this.provides = ImmutableSet.copyOf((Collection)mutableProvideList);
    }

    @Override
    public String getModule() {
        return "not used";
    }

    @Override
    public Class<WhenHandlerValidator> getValidatorClass() {
        return WhenHandlerValidator.class;
    }

    @Override
    @Nonnull
    public Set<String> getProvides() {
        return this.provides;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }
}

