/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.descriptors;

import com.atlassian.fugue.Option;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.servicedesk.plugins.automation.internal.descriptors.AbstractRuleComponentModuleDescriptor;
import com.atlassian.servicedesk.plugins.automation.internal.descriptors.condition.ConditionDescriptorFactory;
import com.atlassian.servicedesk.plugins.automation.internal.spi.descriptors.IfConditionModuleDescriptor;
import com.atlassian.servicedesk.plugins.automation.spi.ruleif.IfCondition;
import com.atlassian.servicedesk.plugins.automation.spi.ruleif.IfConditionValidator;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class IfConditionModuleDescriptorImpl
extends AbstractRuleComponentModuleDescriptor<IfCondition, IfConditionValidator>
implements IfConditionModuleDescriptor {
    private static final Logger log = LoggerFactory.getLogger(IfConditionModuleDescriptorImpl.class);
    private ImmutableSet<String> requires;

    @Autowired
    public IfConditionModuleDescriptorImpl(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory, ConditionDescriptorFactory conditionDescriptorFactory) {
        super(authenticationContext, moduleFactory, conditionDescriptorFactory);
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        HashSet mutableRequiresList = Sets.newHashSet();
        Option requiresElementOption = Option.option((Object)element.element("requires"));
        if (requiresElementOption.isDefined()) {
            Element requiresElement = (Element)requiresElementOption.get();
            Iterator requireListIterator = requiresElement.elementIterator("require");
            while (requireListIterator.hasNext()) {
                Object requireElement = requireListIterator.next();
                if (requireElement != null && requireElement instanceof Element) {
                    String require = ((Element)requireElement).getText();
                    if (require != null && StringUtils.isNotBlank((String)require.trim())) {
                        mutableRequiresList.add(require.toLowerCase().trim());
                        continue;
                    }
                    log.debug("A 'require' element is empty for " + this.getCompleteKey());
                    continue;
                }
                log.debug("A 'require' element is invalid " + this.getCompleteKey());
            }
        } else {
            log.debug("No 'requires' element provided for " + this.getCompleteKey());
        }
        this.requires = ImmutableSet.copyOf((Collection)mutableRequiresList);
    }

    @Override
    public Class<IfConditionValidator> getValidatorClass() {
        return IfConditionValidator.class;
    }

    @Override
    @Nonnull
    public Set<String> getRequires() {
        return this.requires;
    }
}

