/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.descriptors;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.fugue.Option;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.servicedesk.plugins.automation.internal.descriptors.AbstractConditionalAutomationModuleDescriptor;
import com.atlassian.servicedesk.plugins.automation.internal.descriptors.condition.ConditionDescriptorFactory;
import com.atlassian.servicedesk.plugins.automation.spi.blueprint.Blueprint;
import com.atlassian.util.concurrent.LazyReference;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;

public class BlueprintModuleDescriptor
extends AbstractConditionalAutomationModuleDescriptor<Blueprint> {
    private final Long DEFAULT_WEIGHT = 9999L;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private Element element;
    private Option<String> helpTitleKey;
    private Option<String> helpDescriptionKey;
    private Option<String> helpTemplate;
    private Option<Long> weight;
    @TenantAware(value=TenancyScope.TENANTLESS)
    private final LazyReference<Blueprint> moduleReference = new LazyReference<Blueprint>(){

        protected Blueprint create() throws Exception {
            return BlueprintModuleDescriptor.this.createModule();
        }
    };
    @TenantAware(value=TenancyScope.TENANTLESS)
    private final LazyReference<Option<String>> iconPathRef = new LazyReference<Option<String>>(){

        protected Option<String> create() throws Exception {
            String iconText;
            Option iconOption;
            Option moduleDescriptorOption;
            String attributeText;
            Option attributeOption;
            Option resourceElement = Option.option((Object)BlueprintModuleDescriptor.this.element.element("resource"));
            if (resourceElement.isDefined() && (attributeOption = Option.option((Object)((Element)resourceElement.get()).attribute("name"))).isDefined() && StringUtils.isNotBlank((String)(attributeText = ((Attribute)attributeOption.get()).getText())) && (moduleDescriptorOption = Option.option((Object)BlueprintModuleDescriptor.this.plugin.getModuleDescriptor(attributeText))).isDefined() && (iconOption = Option.option((Object)((Element)resourceElement.get()).element("icon"))).isDefined() && StringUtils.isNotBlank((String)(iconText = ((Element)iconOption.get()).getTextTrim()))) {
                return Option.option((Object)BlueprintModuleDescriptor.this.webResourceUrlProvider.getStaticPluginResourceUrl((ModuleDescriptor)moduleDescriptorOption.get(), iconText, UrlMode.RELATIVE));
            }
            return Option.none();
        }
    };

    @Autowired
    public BlueprintModuleDescriptor(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory, WebResourceUrlProvider webResourceUrlProvider, ConditionDescriptorFactory conditionDescriptorFactory) {
        super(authenticationContext, moduleFactory, conditionDescriptorFactory);
        this.webResourceUrlProvider = webResourceUrlProvider;
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        Option templateOpt;
        super.init(plugin, element);
        this.element = element;
        Option helpTitleOpt = Option.option((Object)element.element("help-title"));
        this.helpTitleKey = this.extractKeyAttribute((Option<Element>)helpTitleOpt);
        Option helpDescriptionOpt = Option.option((Object)element.element("help-description"));
        this.helpDescriptionKey = this.extractKeyAttribute((Option<Element>)helpDescriptionOpt);
        this.weight = this.extractLongAttribute(element, "weight");
        this.helpTemplate = Option.none();
        Option helpTemplateOpt = Option.option((Object)element.element("help-template"));
        if (helpTemplateOpt.isDefined() && (templateOpt = Option.option((Object)((Element)helpTemplateOpt.get()).getText())).isDefined()) {
            String templateKey = (String)templateOpt.get();
            String completeTemplateKey = templateKey.contains(":") ? templateKey : String.format("%s:%s", plugin.getKey(), templateKey);
            this.helpTemplate = Option.some((Object)completeTemplateKey);
        }
    }

    private Option<String> extractKeyAttribute(Option<Element> elementOpt) {
        if (elementOpt.isDefined()) {
            return Option.option((Object)((Element)elementOpt.get()).attributeValue("key"));
        }
        return Option.none();
    }

    private Option<Long> extractLongAttribute(Element element, String attribute) {
        String rawValue = element.attributeValue(attribute);
        if (StringUtils.isNotBlank((String)rawValue)) {
            try {
                Long value = Long.valueOf(rawValue);
                return Option.option((Object)value);
            }
            catch (NumberFormatException e) {
                return Option.none();
            }
        }
        return Option.none();
    }

    @Override
    public Blueprint getModule() {
        return (Blueprint)this.moduleReference.get();
    }

    public Option<String> getHelpTitleKey() {
        return this.helpTitleKey;
    }

    public Long getWeight() {
        return (Long)this.weight.getOrElse((Object)this.DEFAULT_WEIGHT);
    }

    public Option<String> getHelpDescriptionKey() {
        return this.helpDescriptionKey;
    }

    public Option<String> getHelpTemplate() {
        return this.helpTemplate;
    }

    @Override
    protected Blueprint createModule() {
        return (Blueprint)this.moduleFactory.createModule(this.moduleClassName, (ModuleDescriptor)this);
    }

    public Option<String> getIconPath() {
        return (Option)this.iconPathRef.get();
    }
}

