/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.configuration.user;

import com.atlassian.fugue.Either;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSet;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RuleSetRunAsUserContextConfigService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RunAsUserContextConfig;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.RuleSetImpl;
import com.atlassian.util.concurrent.Assertions;
import io.atlassian.fugue.Option;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class RuleSetRunAsUserContextConfigServiceImpl
implements RuleSetRunAsUserContextConfigService {
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    public RuleSetRunAsUserContextConfigServiceImpl(@Nonnull ErrorResultHelper errorResultHelper) {
        this.errorResultHelper = errorResultHelper;
    }

    @Nonnull
    public Either<AnError, com.atlassian.fugue.Option<RunAsUserContextConfig>> getRunAsUserContextConfigForRuleSet(@Nonnull RuleSet ruleSet) {
        Assertions.notNull((String)"ruleSet", (Object)ruleSet);
        return StepsConverters.olderEither(this.getContextForRuleSetWithoutPermissionChecking(ruleSet)).map(StepsConverters::olderOption);
    }

    @Nonnull
    private io.atlassian.fugue.Either<AnError, Option<RunAsUserContextConfig>> getContextForRuleSetWithoutPermissionChecking(@Nonnull RuleSet ruleSet) {
        try {
            Option ruleSetUserContext = StepsConverters.newerOption(((RuleSetImpl)ruleSet).getRunAsUserContext());
            return io.atlassian.fugue.Either.right((Object)ruleSetUserContext);
        }
        catch (ClassCastException exception) {
            return StepsConverters.newerEither((Either)this.errorResultHelper.error(HttpStatusCode.INTERNAL_SERVER_ERROR, "ruleset.not.expected.impl", new Object[]{exception}));
        }
    }
}

