/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.validation;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.ozymandias.error.ModuleAccessError;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.When;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.WhenHandlerConfiguration;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.WhenValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.execution.context.project.ProjectContext;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.ComponentConfigurationImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.WhenImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input.ComponentConfigurationInputImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input.WhenInputImpl;
import com.atlassian.servicedesk.plugins.automation.internal.module.WhenHandlerManager;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WhenValidator {
    private final WhenHandlerManager whenHandlerManager;
    private I18nHelper.BeanFactory i18nFactory;

    @Autowired
    public WhenValidator(@Nonnull WhenHandlerManager whenHandlerManager, @Nonnull I18nHelper.BeanFactory i18nFactory) {
        this.whenHandlerManager = whenHandlerManager;
        this.i18nFactory = i18nFactory;
    }

    public WhenValidationResult validateWhenInput(@Nonnull ApplicationUser user, @Nonnull WhenInputImpl when, @Nonnull Option<ProjectContext> projectContext) {
        Assertions.notNull((String)"user is required", (Object)user);
        Assertions.notNull((String)"when is required", (Object)when);
        Assertions.notNull((String)"projectContext", projectContext);
        ValidationResult validationResult = this.validateSelf(user, when.getWhenHandlerConfigurations());
        List whenHandlerValidationResults = Lists.transform(when.getWhenHandlerConfigurations(), whenHandler -> this.validateWhenHandlerInput(user, (ComponentConfigurationInputImpl)whenHandler, projectContext));
        return new WhenValidationResult(validationResult, whenHandlerValidationResults);
    }

    public ValidationResult validateWhenHandlerInput(@Nonnull ApplicationUser user, @Nonnull ComponentConfigurationInputImpl componentConfigurationInput, @Nonnull Option<ProjectContext> projectContext) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"componentConfigurationInput", (Object)componentConfigurationInput);
        Assertions.notNull((String)"projectContext", projectContext);
        String moduleKey = (String)componentConfigurationInput.getModuleKey().getOrNull();
        if (StringUtils.isBlank((String)moduleKey)) {
            return ValidationResult.FAILED((List)Lists.newArrayList((Object[])new String[]{this.getI18n(user).getText("sd.automation.rule.set.error.component.module.key.missing")}));
        }
        ComponentConfigurationImpl whenHandlerConfiguration = new ComponentConfigurationImpl(-1L, moduleKey, componentConfigurationInput.getData());
        return this.validateWhenHandler(user, whenHandlerConfiguration, projectContext);
    }

    public WhenValidationResult validateWhen(@Nonnull ApplicationUser user, @Nonnull When when, @Nonnull Option<ProjectContext> projectContext) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"when", (Object)when);
        Assertions.notNull((String)"projectContext", projectContext);
        ValidationResult validationResult = this.validateSelf(user, when.getWhenHandlerConfigurations());
        List whenValidationResult = Lists.transform((List)when.getWhenHandlerConfigurations(), whenHandler -> this.validateWhenHandler(user, (WhenHandlerConfiguration)whenHandler, projectContext));
        return new WhenValidationResult(validationResult, whenValidationResult);
    }

    public When transformInput(@Nonnull WhenInputImpl when) {
        Assertions.notNull((String)"when is required", (Object)when);
        List whenHandlerConfigurations = Lists.transform(when.getWhenHandlerConfigurations(), whenHandlerConfiguration -> {
            Assertions.notNull((String)"moduleKey is required", (Object)whenHandlerConfiguration.getModuleKey().getOrNull());
            return new ComponentConfigurationImpl(-1L, (String)whenHandlerConfiguration.getModuleKey().get(), whenHandlerConfiguration.getData());
        });
        return new WhenImpl(whenHandlerConfigurations);
    }

    private ValidationResult validateWhenHandler(ApplicationUser user, WhenHandlerConfiguration whenHandlerConfiguration, Option<ProjectContext> projectContext) {
        Either<? extends ModuleAccessError, ValidationResult> result = this.whenHandlerManager.validateWhenHandler(user, whenHandlerConfiguration, projectContext);
        if (result.isLeft()) {
            String errorMessage = ((ModuleAccessError)result.left().get()).getErrorMessage();
            return ValidationResult.FAILED((List)Lists.newArrayList((Object[])new String[]{this.getI18n(user).getText("sd.automation.rule.set.error.component.failed.to.execute.validator", whenHandlerConfiguration.getModuleKey(), errorMessage)}));
        }
        return (ValidationResult)result.right().get();
    }

    private ValidationResult validateSelf(@Nonnull ApplicationUser user, @Nonnull List<?> whenHandlerConfigurations) {
        ArrayList componentErrors = Lists.newArrayList();
        if (whenHandlerConfigurations.isEmpty()) {
            componentErrors.add(this.getI18n(user).getText("sd.automation.rule.set.error.rule.must.contain.an.when.handler"));
        }
        return !componentErrors.isEmpty() ? ValidationResult.FAILED((List)componentErrors) : ValidationResult.PASSED();
    }

    private I18nHelper getI18n(ApplicationUser user) {
        return this.i18nFactory.getInstance(user);
    }
}

