/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.validation;

import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.Rule;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidatedRuleSet;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RunAsUserContextConfig;
import com.atlassian.servicedesk.plugins.automation.api.execution.context.project.ProjectContext;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class ValidatedRuleSetImpl
implements ValidatedRuleSet {
    private final String name;
    private final Option<String> description;
    private final List<Rule> rules;
    private final Option<RunAsUserContextConfig> runAsUserContext;
    private final ProjectContext projectContext;
    private final boolean triggerFromOtherRules;
    private final boolean isSystemRuleSet;

    public ValidatedRuleSetImpl(@Nonnull List<Rule> rules, @Nonnull ProjectContext projectContext, @Nonnull String name, @Nonnull Option<RunAsUserContextConfig> runAsUserContext, @Nonnull Option<String> description, boolean triggerFromOtherRules, boolean isSystemRuleSet) {
        Assertions.notNull((String)"rules is required", rules);
        Assertions.notNull((String)"name is required", (Object)name);
        Assertions.isTrue((String)"name cannot be empty", (boolean)StringUtils.isNotBlank((String)name));
        Assertions.notNull((String)"runAsUserContext is required", runAsUserContext);
        Assertions.notNull((String)"projectContext is required", (Object)projectContext);
        Assertions.notNull((String)"description is required", description);
        this.name = name;
        this.projectContext = projectContext;
        this.runAsUserContext = runAsUserContext;
        this.description = description;
        this.rules = ImmutableList.copyOf(rules);
        this.triggerFromOtherRules = triggerFromOtherRules;
        this.isSystemRuleSet = isSystemRuleSet;
    }

    public ProjectContext getProjectContext() {
        return this.projectContext;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Option<String> getDescription() {
        return this.description;
    }

    public boolean getTriggerFromOtherRules() {
        return this.triggerFromOtherRules;
    }

    @Nonnull
    public List<Rule> getRules() {
        return Lists.newArrayList(this.rules);
    }

    @Nonnull
    public Option<RunAsUserContextConfig> getRunAsUserContext() {
        return this.runAsUserContext;
    }

    @Nonnull
    public boolean isSystemRuleSet() {
        return this.isSystemRuleSet;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("description", this.description).add("rules", this.rules).add("runAsUserContext", this.runAsUserContext).add("projectContext", (Object)this.projectContext).add("isSystemRuleSet", this.isSystemRuleSet).toString();
    }
}

