/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.validation;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.Rule;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSet;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.WhenHandlerConfiguration;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInput;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.RuleSetValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidatedRuleSet;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RuleSetRunAsUserContextConfigService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RunAsUserContextConfig;
import com.atlassian.servicedesk.plugins.automation.api.execution.context.project.ProjectContext;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.project.InternalRuleSetProjectContextConfigService;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input.ComponentConfigurationInputImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input.RuleInputImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input.RuleMetadataInputImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input.RuleSetInputImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.validation.RuleValidator;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.validation.ValidatedRuleSetImpl;
import com.atlassian.servicedesk.plugins.automation.internal.execution.context.project.ProjectContextImpl;
import com.atlassian.servicedesk.plugins.automation.internal.module.WhenHandlerManager;
import com.atlassian.servicedesk.plugins.automation.internal.module.WhenHandlerModuleData;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RuleSetValidator {
    private final RuleValidator ruleValidator;
    private final I18nHelper.BeanFactory i18nFactory;
    private final InternalRuleSetProjectContextConfigService ruleSetProjectContextConfigService;
    private final WhenHandlerManager whenHandlerManager;
    private final RuleSetRunAsUserContextConfigService ruleSetRunAsUserContextConfigService;

    @Autowired
    public RuleSetValidator(RuleValidator ruleValidator, I18nHelper.BeanFactory i18nFactory, InternalRuleSetProjectContextConfigService ruleSetProjectContextConfigService, WhenHandlerManager whenHandlerManager, RuleSetRunAsUserContextConfigService ruleSetRunAsUserContextConfigService) {
        this.ruleValidator = ruleValidator;
        this.i18nFactory = i18nFactory;
        this.ruleSetProjectContextConfigService = ruleSetProjectContextConfigService;
        this.whenHandlerManager = whenHandlerManager;
        this.ruleSetRunAsUserContextConfigService = ruleSetRunAsUserContextConfigService;
    }

    public RuleSetValidationResult validateRuleSetInput(@Nonnull ApplicationUser user, @Nonnull RuleSetInput ruleSetInput) {
        Assertions.notNull((String)"user is required", (Object)user);
        Assertions.notNull((String)"ruleSetInput is required", (Object)ruleSetInput);
        RuleSetInputImpl ruleSet = (RuleSetInputImpl)ruleSetInput;
        io.atlassian.fugue.Option<ProjectContext> projectContext = this.ruleSetProjectContextConfigService.getProjectContextForInput(ruleSetInput);
        ValidationResult validationResult = this.validateSelfInput(user, ruleSet.getRuleInputs(), ruleSet.getName(), ruleSet.getDescription(), ruleSet.getRuleMetadata().getTriggerFromOtherRules(), ruleSet.getRuleMetadata().getRuleMetadataUserContextInput().getUserContext());
        List ruleValidationResults = Lists.transform(ruleSet.getRuleInputs(), ruleConfiguration -> this.ruleValidator.validateRuleInput(user, (RuleInputImpl)ruleConfiguration, projectContext));
        return new RuleSetValidationResult(validationResult, ruleValidationResults);
    }

    public RuleSetValidationResult validateRuleSet(@Nonnull ApplicationUser user, @Nonnull RuleSet ruleSet) {
        Assertions.notNull((String)"user is required", (Object)user);
        Assertions.notNull((String)"ruleSet is required", (Object)ruleSet);
        io.atlassian.fugue.Option projectContext = this.ruleSetProjectContextConfigService.getProjectContext(ruleSet).right().toOption();
        io.atlassian.fugue.Either runAsUserContextConfigForRuleSetResult = StepsConverters.newerEither((Either)this.ruleSetRunAsUserContextConfigService.getRunAsUserContextConfigForRuleSet(ruleSet)).map(StepsConverters::newerOption);
        if (runAsUserContextConfigForRuleSetResult.isLeft()) {
            return RuleSetValidationResult.withGlobalRuleSetErrors((String[])new String[]{((AnError)runAsUserContextConfigForRuleSetResult.left().get()).getMessage().getMessage()});
        }
        ValidationResult validationResult = this.validateSelf(user, ruleSet.getRules(), (io.atlassian.fugue.Option<String>)io.atlassian.fugue.Option.some((Object)ruleSet.getName()), (io.atlassian.fugue.Option<String>)StepsConverters.newerOption((Option)ruleSet.getDescription()), (io.atlassian.fugue.Option<Boolean>)io.atlassian.fugue.Option.some((Object)ruleSet.getTriggerFromOtherRules()), (io.atlassian.fugue.Option<RunAsUserContextConfig>)((io.atlassian.fugue.Option)runAsUserContextConfigForRuleSetResult.right().get()));
        List ruleValidationResults = Lists.transform((List)ruleSet.getRules(), ruleConfiguration -> this.ruleValidator.validateRule(user, (Rule)ruleConfiguration, (io.atlassian.fugue.Option<ProjectContext>)projectContext));
        return new RuleSetValidationResult(validationResult, ruleValidationResults);
    }

    public ValidatedRuleSet transformInput(@Nonnull RuleSetInput ruleSetInput) {
        Assertions.notNull((String)"ruleSetInput is required", (Object)ruleSetInput);
        RuleSetInputImpl ruleSet = (RuleSetInputImpl)ruleSetInput;
        List validatedRules = Lists.transform(ruleSet.getRuleInputs(), this.ruleValidator::transformInput);
        String name = ((String)ruleSet.getName().get()).trim();
        BooleanUtils.isTrue((Boolean)StringUtils.isNotBlank((String)name));
        String description = ((String)ruleSet.getDescription().getOrElse((Object)"")).trim();
        io.atlassian.fugue.Option descriptionOption = io.atlassian.fugue.Option.none();
        if (StringUtils.isNotBlank((String)description)) {
            descriptionOption = io.atlassian.fugue.Option.some((Object)description);
        }
        RuleMetadataInputImpl ruleMetadata = ruleSet.getRuleMetadata();
        io.atlassian.fugue.Option<RunAsUserContextConfig> runAsUserContext = ruleMetadata.getRuleMetadataUserContextInput().getUserContext();
        io.atlassian.fugue.Option<Project> project = ruleMetadata.getRuleMetadataProjectInput().getProject();
        boolean triggerFromOtherRules = (Boolean)ruleMetadata.getTriggerFromOtherRules().get();
        return new ValidatedRuleSetImpl(validatedRules, this.convertToProjectContextConfig(project), name, runAsUserContext, (io.atlassian.fugue.Option<String>)descriptionOption, triggerFromOtherRules, ruleSet.isSystemRuleSet());
    }

    private ProjectContext convertToProjectContextConfig(io.atlassian.fugue.Option<Project> project) {
        ArrayList projectContextProjects = Lists.newArrayList();
        if (project.isDefined()) {
            projectContextProjects.add(project.get());
        }
        return new ProjectContextImpl(projectContextProjects);
    }

    private ValidationResult validateSelf(ApplicationUser user, List<Rule> rules, io.atlassian.fugue.Option<String> name, io.atlassian.fugue.Option<String> description, io.atlassian.fugue.Option<Boolean> triggerFromOtherRules, io.atlassian.fugue.Option<RunAsUserContextConfig> runAsUserContextOpt) {
        ArrayList componentErrors = Lists.newArrayList();
        HashMap fieldErrors = Maps.newHashMap();
        if (name.isEmpty() || StringUtils.isBlank((String)((String)name.get()))) {
            ArrayList errors = Lists.newArrayList((Object[])new String[]{this.getI18n(user).getText("sd.automation.rule.set.error.rule.set.name.missing")});
            fieldErrors.put("name", errors);
        }
        if (triggerFromOtherRules.isEmpty()) {
            componentErrors.add(this.getI18n(user).getText("sd.automation.rule.set.error.rule.set.trigger.from.other.rules.missing"));
        }
        if (rules.isEmpty()) {
            componentErrors.add(this.getI18n(user).getText("sd.automation.rule.set.error.rule.set.must.contain.a.rule"));
        }
        if (!this.isUserContextValid(rules, runAsUserContextOpt)) {
            componentErrors.add(this.getI18n(user).getText("sd.automation.rule.set.error.rule.set.user.context.invalid"));
        }
        return !componentErrors.isEmpty() || !fieldErrors.isEmpty() ? ValidationResult.FAILED((List)componentErrors, (Map)fieldErrors) : ValidationResult.PASSED();
    }

    private ValidationResult validateSelfInput(ApplicationUser user, List<RuleInputImpl> rules, io.atlassian.fugue.Option<String> name, io.atlassian.fugue.Option<String> description, io.atlassian.fugue.Option<Boolean> triggerFromOtherRules, io.atlassian.fugue.Option<RunAsUserContextConfig> runAsUserContextOpt) {
        ArrayList componentErrors = Lists.newArrayList();
        HashMap fieldErrors = Maps.newHashMap();
        if (name.isEmpty() || StringUtils.isBlank((String)((String)name.get()))) {
            ArrayList errors = Lists.newArrayList((Object[])new String[]{this.getI18n(user).getText("sd.automation.rule.set.error.rule.set.name.missing")});
            fieldErrors.put("name", errors);
        }
        if (triggerFromOtherRules.isEmpty()) {
            componentErrors.add(this.getI18n(user).getText("sd.automation.rule.set.error.rule.set.trigger.from.other.rules.missing"));
        }
        if (rules.isEmpty()) {
            componentErrors.add(this.getI18n(user).getText("sd.automation.rule.set.error.rule.set.must.contain.a.rule"));
        }
        if (!this.isUserContextForInputValid(rules, runAsUserContextOpt)) {
            componentErrors.add(this.getI18n(user).getText("sd.automation.rule.set.error.rule.set.user.context.invalid"));
        }
        return !componentErrors.isEmpty() || !fieldErrors.isEmpty() ? ValidationResult.FAILED((List)componentErrors, (Map)fieldErrors) : ValidationResult.PASSED();
    }

    private boolean isUserContextValid(List<Rule> rules, io.atlassian.fugue.Option<RunAsUserContextConfig> runAsUserContextOpt) {
        List<WhenHandlerModuleData> whenHandlerModuleDataList = this.whenHandlerManager.getWhenHandlerModuleDataList();
        if (runAsUserContextOpt.isDefined()) {
            for (Rule rule : rules) {
                for (WhenHandlerConfiguration whenConfig : rule.getWhen().getWhenHandlerConfigurations()) {
                    for (WhenHandlerModuleData moduleData : whenHandlerModuleDataList) {
                        if (!moduleData.getModuleKey().equals(whenConfig.getModuleKey()) || moduleData.getProvides().contains("user")) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean isUserContextForInputValid(List<RuleInputImpl> rules, io.atlassian.fugue.Option<RunAsUserContextConfig> runAsUserContextOpt) {
        List<WhenHandlerModuleData> whenHandlerModuleDataList = this.whenHandlerManager.getWhenHandlerModuleDataList();
        if (runAsUserContextOpt.isDefined()) {
            for (RuleInputImpl rule : rules) {
                for (ComponentConfigurationInputImpl whenConfig : rule.getWhenInputs().getWhenHandlerConfigurations()) {
                    for (WhenHandlerModuleData moduleData : whenHandlerModuleDataList) {
                        io.atlassian.fugue.Option<String> moduleKeyOpt = whenConfig.getModuleKey();
                        if (!moduleKeyOpt.isDefined() || !moduleData.getModuleKey().equals(moduleKeyOpt.get()) || moduleData.getProvides().contains("user")) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private I18nHelper getI18n(ApplicationUser user) {
        return this.i18nFactory.getInstance(user);
    }
}

