/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.validation;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.ozymandias.error.ModuleAccessError;
import com.atlassian.ozymandias.error.ModuleNotFoundError;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.If;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.IfConditionConfiguration;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.IfValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.execution.context.project.ProjectContext;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.ComponentConfigurationImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.IfImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input.ComponentConfigurationInputImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.input.IfInputImpl;
import com.atlassian.servicedesk.plugins.automation.internal.module.IfConditionManager;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IfValidator {
    private final IfConditionManager ifConditionManager;
    private I18nHelper.BeanFactory i18nFactory;

    @Autowired
    public IfValidator(IfConditionManager ifConditionManager, I18nHelper.BeanFactory i18nFactory) {
        this.ifConditionManager = ifConditionManager;
        this.i18nFactory = i18nFactory;
    }

    public IfValidationResult validateIfInput(final @Nonnull ApplicationUser user, @Nonnull IfInputImpl ruleIfInput, boolean lastIfThen, final @Nonnull Option<ProjectContext> projectContext) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"ruleIfInput", (Object)ruleIfInput);
        Assertions.notNull((String)"projectContext", projectContext);
        ValidationResult ifValidationResult = this.validateSelf(user, lastIfThen, ruleIfInput.getIfConditionConfigurationInputs());
        List ifConditionValidationResults = Lists.transform(ruleIfInput.getIfConditionConfigurationInputs(), (Function)new Function<ComponentConfigurationInputImpl, ValidationResult>(){

            public ValidationResult apply(ComponentConfigurationInputImpl ifConditionConfiguration) {
                return IfValidator.this.validationIfConditionInput(user, ifConditionConfiguration, (Option<ProjectContext>)projectContext);
            }
        });
        return new IfValidationResult(ifValidationResult, ifConditionValidationResults);
    }

    public ValidationResult validationIfConditionInput(@Nonnull ApplicationUser user, @Nonnull ComponentConfigurationInputImpl componentConfigurationInput, @Nonnull Option<ProjectContext> projectContext) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"componentConfigurationInput", (Object)componentConfigurationInput);
        Assertions.notNull((String)"projectContext", projectContext);
        String moduleKey = (String)componentConfigurationInput.getModuleKey().getOrNull();
        if (StringUtils.isBlank((String)moduleKey)) {
            return ValidationResult.FAILED((List)Lists.newArrayList((Object[])new String[]{this.getI18n(user).getText("sd.automation.rule.set.error.component.module.key.missing")}));
        }
        ComponentConfigurationImpl ifConditionConfiguration = new ComponentConfigurationImpl(-1L, moduleKey, componentConfigurationInput.getData());
        return this.validateIfCondition(user, ifConditionConfiguration, projectContext);
    }

    public IfValidationResult validateIf(final @Nonnull ApplicationUser user, @Nonnull If ruleIf, boolean lastIfThen, final @Nonnull Option<ProjectContext> projectContext) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"ruleIf", (Object)ruleIf);
        Assertions.notNull((String)"projectContext", projectContext);
        ValidationResult validationResult = this.validateSelf(user, lastIfThen, ruleIf.getIfConditionConfigurations());
        List ifConditionValidationResults = Lists.transform((List)ruleIf.getIfConditionConfigurations(), (Function)new Function<IfConditionConfiguration, ValidationResult>(){

            public ValidationResult apply(IfConditionConfiguration ifConditionConfiguration) {
                return IfValidator.this.validateIfCondition(user, ifConditionConfiguration, (Option<ProjectContext>)projectContext);
            }
        });
        return new IfValidationResult(validationResult, ifConditionValidationResults);
    }

    public If transformInput(@Nonnull IfInputImpl anIf) {
        Assertions.notNull((String)"anIf is required", (Object)anIf);
        List ifConditionConfigurations = Lists.transform(anIf.getIfConditionConfigurationInputs(), (Function)new Function<ComponentConfigurationInputImpl, IfConditionConfiguration>(){

            public IfConditionConfiguration apply(ComponentConfigurationInputImpl ifConfiguration) {
                Assertions.notNull((String)"moduleKey is required", (Object)ifConfiguration.getModuleKey().getOrNull());
                return new ComponentConfigurationImpl(-1L, (String)ifConfiguration.getModuleKey().get(), ifConfiguration.getData());
            }
        });
        return new IfImpl(ifConditionConfigurations);
    }

    private ValidationResult validateSelf(ApplicationUser user, boolean lastIfThen, List<?> ifConditionConfigurations) {
        if (!lastIfThen && ifConditionConfigurations.isEmpty()) {
            return ValidationResult.FAILED((List)Lists.newArrayList((Object[])new String[]{this.getI18n(user).getText("sd.automation.rule.set.error.if.condition.can.not.be.empty")}));
        }
        return ValidationResult.PASSED();
    }

    private ValidationResult validateIfCondition(ApplicationUser user, IfConditionConfiguration ifConfiguration, Option<ProjectContext> projectContext) {
        Either<? extends ModuleAccessError, ValidationResult> result = this.ifConditionManager.validateIfConditionData(user, ifConfiguration, projectContext);
        if (result.isLeft()) {
            ModuleAccessError moduleAccessError = (ModuleAccessError)result.left().get();
            if (moduleAccessError instanceof ModuleNotFoundError) {
                return ValidationResult.FAILED((List)Lists.newArrayList((Object[])new String[]{this.getI18n(user).getText("sd.automation.rule.set.error.component.module.key.unknown", ifConfiguration.getModuleKey())}));
            }
            String errorMessage = ((ModuleAccessError)result.left().get()).getErrorMessage();
            return ValidationResult.FAILED((List)Lists.newArrayList((Object[])new String[]{this.getI18n(user).getText("sd.automation.rule.set.error.component.failed.to.execute.validator", ifConfiguration.getModuleKey(), errorMessage)}));
        }
        return (ValidationResult)result.right().get();
    }

    private I18nHelper getI18n(ApplicationUser user) {
        return this.i18nFactory.getInstance(user);
    }
}

