/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.dao.querydsl;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ThenActionConfiguration;
import com.atlassian.servicedesk.plugins.automation.internal.bootstrap.database.schema.querydsl.QThenActionConfig;
import com.atlassian.servicedesk.plugins.automation.internal.bootstrap.database.schema.querydsl.Tables;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.common.dao.QueryDslDao;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.common.dao.QueryDslDaoHelper;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.ConfigurationDataImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.ProcessedComponentConfigurationImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.dao.querydsl.ThenActionConfigDataDao;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.store.ConfigurationProcessorManager;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

final class ThenActionConfigDao
extends QueryDslDao {
    private final ThenActionConfigDataDao configDataDao;
    private final ConfigurationProcessorManager configurationProcessorManager;

    public ThenActionConfigDao(DatabaseAccessor databaseAccessor, QueryDslDaoHelper helper, ConfigurationProcessorManager configurationProcessorManager) {
        super(databaseAccessor, helper);
        this.configurationProcessorManager = configurationProcessorManager;
        this.configDataDao = new ThenActionConfigDataDao(databaseAccessor, helper);
    }

    long create(@Nonnull DatabaseConnection connection, long ifThenId, @Nonnull ThenActionConfiguration thenActionConfig, int ordinal) {
        Assertions.notNull((String)"connection is required", (Object)connection);
        Assertions.notNull((String)"thenActionConfig is required", (Object)thenActionConfig);
        Assertions.isTrue((String)"ordinal cannot be negative", (ordinal >= 0 ? 1 : 0) != 0);
        long createdThenActionConfigId = this.insertThenActionConfig(connection, ifThenId, thenActionConfig, ordinal);
        ConfigurationData convertedConfigData = this.configurationProcessorManager.preStore(thenActionConfig);
        this.configDataDao.create(connection, createdThenActionConfigId, convertedConfigData);
        return createdThenActionConfigId;
    }

    private long insertThenActionConfig(DatabaseConnection connection, long ifThenId, ThenActionConfiguration thenActionConfig, int ordinal) {
        SQLInsertClause insertStatement = connection.insert((RelationalPath)Tables.THEN_ACTION_CONFIG).set(Tables.THEN_ACTION_CONFIG.IF_THEN_ID, (Object)ifThenId).set((Path)Tables.THEN_ACTION_CONFIG.MODULE_KEY, (Object)thenActionConfig.getModuleKey()).set(Tables.THEN_ACTION_CONFIG.ORDINAL, (Object)ordinal);
        return this.helper.executeSingleRowInsertReturningId(connection, insertStatement, "Failed to insert new row into " + Tables.THEN_ACTION_CONFIG.getTableName());
    }

    public Map<Long, List<ThenActionConfiguration>> getForRuleSetRevisionIds(List<Long> ruleSetRevisionIds) {
        Map<Long, ConfigurationData> config = this.configDataDao.getForRuleSetRevisionIds(ruleSetRevisionIds);
        Stream<Map> rowStream = Lists.partition(ruleSetRevisionIds, (int)1000).stream().flatMap(ids -> ((List)this.databaseAccessor.run(connection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select(QueryDslDaoHelper.constructor(QThenActionConfig.Row.class, Tables.THEN_ACTION_CONFIG)).from((Expression)Tables.THEN_ACTION_CONFIG)).join((EntityPath)Tables.IF_THEN)).on((Predicate)Tables.IF_THEN.ID.eq(Tables.THEN_ACTION_CONFIG.IF_THEN_ID))).join((EntityPath)Tables.RULE)).on((Predicate)Tables.RULE.ID.eq(Tables.IF_THEN.RULE_ID))).where((Predicate)Tables.RULE.RULESET_REVISION_ID.in((Collection)ids))).orderBy(Tables.THEN_ACTION_CONFIG.ORDINAL.asc())).fetch())).stream());
        return rowStream.collect(Collectors.collectingAndThen(Collectors.groupingBy(row -> row.ifThenId, Collectors.mapping(row -> this.createThenActionConfiguration((QThenActionConfig.Row)row, (ConfigurationData)config.get(row.id)), Collectors.toList())), Collections::unmodifiableMap));
    }

    private ThenActionConfiguration createThenActionConfiguration(QThenActionConfig.Row row, ConfigurationData config) {
        return new ProcessedComponentConfigurationImpl(row.id, row.moduleKey, config == null ? ConfigurationDataImpl.EMPTY_INSTANCE : config, this.configurationProcessorManager);
    }

    public List<ThenActionConfiguration> getAllForIfThenWithId(long ifThenId) {
        List returnedRows = (List)this.databaseAccessor.run(connection -> ((SQLQuery)((SQLQuery)((SQLQuery)connection.select(QueryDslDaoHelper.constructor(QThenActionConfig.Row.class, Tables.THEN_ACTION_CONFIG)).from((Expression)Tables.THEN_ACTION_CONFIG)).where((Predicate)Tables.THEN_ACTION_CONFIG.IF_THEN_ID.eq((Object)ifThenId))).orderBy(Tables.THEN_ACTION_CONFIG.ORDINAL.asc())).fetch());
        if (returnedRows.isEmpty()) {
            return Collections.emptyList();
        }
        return this.loadThenActionConfigsFromDbRows(returnedRows);
    }

    private List<ThenActionConfiguration> loadThenActionConfigsFromDbRows(List<QThenActionConfig.Row> dbRows) {
        ImmutableList.Builder loadedThenActionConfigs = ImmutableList.builder();
        for (QThenActionConfig.Row row : dbRows) {
            loadedThenActionConfigs.add((Object)this.loadThenActionConfigFromDbRow(row));
        }
        return loadedThenActionConfigs.build();
    }

    private ThenActionConfiguration loadThenActionConfigFromDbRow(QThenActionConfig.Row thenActionConfigRow) {
        ConfigurationData configDataForThenActionConfig = this.configDataDao.getForThenActionConfigWithId(thenActionConfigRow.id);
        return new ProcessedComponentConfigurationImpl(thenActionConfigRow.id, thenActionConfigRow.moduleKey, configDataForThenActionConfig, this.configurationProcessorManager);
    }
}

