/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.dao.querydsl;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RunAsUserContextConfig;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RunAsUserContextConfigFactory;
import com.atlassian.servicedesk.plugins.automation.internal.bootstrap.database.schema.querydsl.QRuleSetRevisionUserContext;
import com.atlassian.servicedesk.plugins.automation.internal.bootstrap.database.schema.querydsl.Tables;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.common.dao.QueryDslDao;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.common.dao.QueryDslDaoHelper;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.user.RunAsUserContextConfigDataExtractor;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

class RuleSetRevisionUserContextDao
extends QueryDslDao {
    private final RunAsUserContextConfigFactory runAsUserContextConfigFactory;

    RuleSetRevisionUserContextDao(DatabaseAccessor databaseAccessor, QueryDslDaoHelper helper, RunAsUserContextConfigFactory runAsUserContextConfigFactory) {
        super(databaseAccessor, helper);
        this.runAsUserContextConfigFactory = runAsUserContextConfigFactory;
    }

    void create(@Nonnull DatabaseConnection connection, long createdRuleSetRevisionId, @Nonnull Option<RunAsUserContextConfig> runAsUserContext) {
        Assertions.notNull((String)"connection is required", (Object)connection);
        Assertions.notNull((String)"runAsUserContext is required", runAsUserContext);
        if (runAsUserContext.isEmpty()) {
            return;
        }
        RunAsUserContextConfig toInsert = (RunAsUserContextConfig)runAsUserContext.get();
        RunAsUserContextConfigDataExtractor.RunAsUserContextConfigData extracted = RunAsUserContextConfigDataExtractor.extract(toInsert);
        SQLInsertClause insertStatement = connection.insert((RelationalPath)Tables.RULE_SET_REVISION_USER_CONTEXT).set(Tables.RULE_SET_REVISION_USER_CONTEXT.RULESET_REVISION_ID, (Object)createdRuleSetRevisionId).set((Path)Tables.RULE_SET_REVISION_USER_CONTEXT.STRATEGY, (Object)extracted.strategyName).set((Path)Tables.RULE_SET_REVISION_USER_CONTEXT.USER_KEY, extracted.userKey.getOrNull());
        this.helper.executeExpectingNRowUpdates(insertStatement, 1L, "Failed to insert new row into " + Tables.RULE_SET_REVISION_USER_CONTEXT.getTableName());
    }

    public Map<Long, RunAsUserContextConfig> getForRuleSetRevisionIds(List<Long> ruleSetRevisionIds) {
        Stream<Map> rowStream = Lists.partition(ruleSetRevisionIds, (int)1000).stream().flatMap(ids -> ((List)this.databaseAccessor.run(connection -> ((SQLQuery)((SQLQuery)connection.select(QueryDslDaoHelper.constructor(QRuleSetRevisionUserContext.Row.class, Tables.RULE_SET_REVISION_USER_CONTEXT)).from((Expression)Tables.RULE_SET_REVISION_USER_CONTEXT)).where((Predicate)Tables.RULE_SET_REVISION_USER_CONTEXT.RULESET_REVISION_ID.in((Collection)ids))).fetch())).stream());
        return rowStream.collect(Collectors.collectingAndThen(Collectors.toMap(r -> r.rulesetRevisionId, r -> this.runAsUserContextConfigFactory.forStrategyNameAndUserKey(r.strategy, StepsConverters.olderOption((Option)Option.option((Object)r.userKey)))), Collections::unmodifiableMap));
    }

    public Option<RunAsUserContextConfig> getForRuleSetRevisionWithId(long ruleSetRevisionId) {
        QRuleSetRevisionUserContext.Row userContextRow = (QRuleSetRevisionUserContext.Row)this.databaseAccessor.run(connection -> (QRuleSetRevisionUserContext.Row)((SQLQuery)((SQLQuery)connection.select(QueryDslDaoHelper.constructor(QRuleSetRevisionUserContext.Row.class, Tables.RULE_SET_REVISION_USER_CONTEXT)).from((Expression)Tables.RULE_SET_REVISION_USER_CONTEXT)).where((Predicate)Tables.RULE_SET_REVISION_USER_CONTEXT.RULESET_REVISION_ID.eq((Object)ruleSetRevisionId))).fetchOne());
        if (userContextRow == null) {
            return Option.none();
        }
        RunAsUserContextConfig parsedFromRow = this.runAsUserContextConfigFactory.forStrategyNameAndUserKey(userContextRow.strategy, StepsConverters.olderOption((Option)Option.option((Object)userContextRow.userKey)));
        return Option.option((Object)parsedFromRow);
    }
}

