/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.dao.querydsl;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.plugins.automation.api.configuration.project.ProjectContextConfig;
import com.atlassian.servicedesk.plugins.automation.internal.bootstrap.database.schema.querydsl.QRuleSetRevisionProjectContext;
import com.atlassian.servicedesk.plugins.automation.internal.bootstrap.database.schema.querydsl.Tables;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.common.dao.QueryDslDao;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.common.dao.QueryDslDaoHelper;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.project.ProjectContextConfigImpl;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class RuleSetRevisionProjectContextDao
extends QueryDslDao {
    RuleSetRevisionProjectContextDao(DatabaseAccessor databaseAccessor, QueryDslDaoHelper helper) {
        super(databaseAccessor, helper);
    }

    public void create(@Nonnull DatabaseConnection connection, long createdRuleSetRevisionId, @Nonnull ProjectContextConfig projectContextConfig) {
        Assertions.notNull((String)"connection", (Object)connection);
        Assertions.notNull((String)"projectContextConfig", (Object)projectContextConfig);
        if (projectContextConfig.isGlobal()) {
            return;
        }
        List projectIdsToInsert = projectContextConfig.getProjectIds();
        SQLInsertClause batchInsertStatement = connection.insert((RelationalPath)Tables.RULE_SET_REVISION_PROJECT_CONTEXT);
        Iterator iterator = projectIdsToInsert.iterator();
        while (iterator.hasNext()) {
            long projectId = (Long)iterator.next();
            batchInsertStatement.set(Tables.RULE_SET_REVISION_PROJECT_CONTEXT.RULESET_REVISION_ID, (Object)createdRuleSetRevisionId);
            batchInsertStatement.set(Tables.RULE_SET_REVISION_PROJECT_CONTEXT.PROJECT_ID, (Object)projectId);
            batchInsertStatement.addBatch();
        }
        this.helper.executeExpectingNRowUpdates(batchInsertStatement, projectIdsToInsert.size(), "Failed to insert ruleset revision project context project ids");
    }

    public Map<Long, ProjectContextConfig> getForRuleSetRevisionIds(List<Long> ruleSetRevisionIds) {
        Stream<Map> rowStream = Lists.partition(ruleSetRevisionIds, (int)1000).stream().flatMap(ids -> ((List)this.databaseAccessor.run(connection -> ((SQLQuery)((SQLQuery)((SQLQuery)connection.select(QueryDslDaoHelper.constructor(QRuleSetRevisionProjectContext.Row.class, Tables.RULE_SET_REVISION_PROJECT_CONTEXT)).from((Expression)Tables.RULE_SET_REVISION_PROJECT_CONTEXT)).where((Predicate)Tables.RULE_SET_REVISION_PROJECT_CONTEXT.RULESET_REVISION_ID.in((Collection)ids))).orderBy(Tables.RULE_SET_REVISION_PROJECT_CONTEXT.RULESET_REVISION_ID.asc())).fetch())).stream());
        return rowStream.collect(Collectors.collectingAndThen(Collectors.groupingBy(r -> r.rulesetRevisionId, Collectors.mapping(r -> r.projectId, Collectors.collectingAndThen(Collectors.toList(), ProjectContextConfigImpl::new))), Collections::unmodifiableMap));
    }

    public ProjectContextConfig getForRuleSetRevisionWithId(long ruleSetRevisionId) {
        List projectContextRows = (List)this.databaseAccessor.run(connection -> ((SQLQuery)((SQLQuery)connection.select(QueryDslDaoHelper.constructor(QRuleSetRevisionProjectContext.Row.class, Tables.RULE_SET_REVISION_PROJECT_CONTEXT)).from((Expression)Tables.RULE_SET_REVISION_PROJECT_CONTEXT)).where((Predicate)Tables.RULE_SET_REVISION_PROJECT_CONTEXT.RULESET_REVISION_ID.eq((Object)ruleSetRevisionId))).fetch());
        ArrayList retrievedProjectIds = Lists.newArrayList();
        for (QRuleSetRevisionProjectContext.Row retrievedRow : projectContextRows) {
            retrievedProjectIds.add(retrievedRow.projectId);
        }
        return new ProjectContextConfigImpl(retrievedProjectIds);
    }
}

