/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.dao.querydsl;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.IfConditionConfiguration;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.IfThen;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ThenActionConfiguration;
import com.atlassian.servicedesk.plugins.automation.internal.bootstrap.database.schema.querydsl.QIfThen;
import com.atlassian.servicedesk.plugins.automation.internal.bootstrap.database.schema.querydsl.Tables;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.common.dao.QueryDslDao;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.common.dao.QueryDslDaoHelper;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.IfImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.IfThenImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.ThenImpl;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.dao.querydsl.IfConditionConfigDao;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.dao.querydsl.ThenActionConfigDao;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.store.ConfigurationProcessorManager;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

final class IfThenDao
extends QueryDslDao {
    private final IfConditionConfigDao ifConditionConfigDao;
    private final ThenActionConfigDao thenActionConfigDao;
    private final ConfigurationProcessorManager configurationProcessorManager;

    IfThenDao(DatabaseAccessor databaseAccessor, QueryDslDaoHelper helper, ConfigurationProcessorManager configurationProcessorManager) {
        super(databaseAccessor, helper);
        this.configurationProcessorManager = configurationProcessorManager;
        this.ifConditionConfigDao = new IfConditionConfigDao(databaseAccessor, helper, configurationProcessorManager);
        this.thenActionConfigDao = new ThenActionConfigDao(databaseAccessor, helper, configurationProcessorManager);
    }

    long create(@Nonnull DatabaseConnection connection, long ruleId, int ordinal, @Nonnull IfThen ifThen) {
        Assertions.notNull((String)"connection is required", (Object)connection);
        Assertions.isTrue((String)"ordinal cannot be negative", (ordinal >= 0 ? 1 : 0) != 0);
        Assertions.notNull((String)"ifThen is required", (Object)ifThen);
        long createdIfThenId = this.insertIfThen(connection, ruleId, ordinal);
        this.insertIfConditionConfigs(connection, ifThen.getIf().getIfConditionConfigurations(), createdIfThenId);
        this.insertThenActionConfigs(connection, ifThen.getThen().getThenActionConfigurations(), createdIfThenId);
        return createdIfThenId;
    }

    private long insertIfThen(DatabaseConnection connection, long ruleId, int ordinal) {
        SQLInsertClause insertStatement = connection.insert((RelationalPath)Tables.IF_THEN).set(Tables.IF_THEN.RULE_ID, (Object)ruleId).set(Tables.IF_THEN.ORDINAL, (Object)ordinal);
        return this.helper.executeSingleRowInsertReturningId(connection, insertStatement, "Failed to insert new row into " + Tables.IF_THEN.getTableName());
    }

    private void insertIfConditionConfigs(DatabaseConnection connection, List<IfConditionConfiguration> ifConditionConfigs, long createdIfThenId) {
        for (int ifCondConfigIndex = 0; ifCondConfigIndex < ifConditionConfigs.size(); ++ifCondConfigIndex) {
            this.ifConditionConfigDao.create(connection, createdIfThenId, ifConditionConfigs.get(ifCondConfigIndex), ifCondConfigIndex + 0);
        }
    }

    private void insertThenActionConfigs(DatabaseConnection connection, List<ThenActionConfiguration> thenActionConfigs, long createdIfThenId) {
        for (int thenActionConfigIndex = 0; thenActionConfigIndex < thenActionConfigs.size(); ++thenActionConfigIndex) {
            this.thenActionConfigDao.create(connection, createdIfThenId, thenActionConfigs.get(thenActionConfigIndex), thenActionConfigIndex + 0);
        }
    }

    public Map<Long, List<IfThen>> getForRuleSetRevisionIds(List<Long> ruleSetRevisionIds) {
        Map<Long, List<IfConditionConfiguration>> ifConditionConfigs = this.ifConditionConfigDao.getForRuleSetRevisionIds(ruleSetRevisionIds);
        Map<Long, List<ThenActionConfiguration>> thenActionConfigs = this.thenActionConfigDao.getForRuleSetRevisionIds(ruleSetRevisionIds);
        Stream<Map> rowStream = Lists.partition(ruleSetRevisionIds, (int)1000).stream().flatMap(ids -> ((List)this.databaseAccessor.run(connection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select(QueryDslDaoHelper.constructor(QIfThen.Row.class, Tables.IF_THEN)).from((Expression)Tables.IF_THEN)).join((EntityPath)Tables.RULE)).on((Predicate)Tables.RULE.ID.eq(Tables.IF_THEN.RULE_ID))).where((Predicate)Tables.RULE.RULESET_REVISION_ID.in((Collection)ids))).orderBy(Tables.IF_THEN.ORDINAL.asc())).fetch())).stream());
        return rowStream.collect(Collectors.collectingAndThen(Collectors.groupingBy(row -> row.ruleId, Collectors.mapping(row -> this.createIfThen((QIfThen.Row)row, (List)ifConditionConfigs.get(row.id), (List)thenActionConfigs.get(row.id)), Collectors.toList())), Collections::unmodifiableMap));
    }

    private IfThen createIfThen(QIfThen.Row ifThenRow, List<IfConditionConfiguration> ifConfig, List<ThenActionConfiguration> thenConfig) {
        return new IfThenImpl(ifThenRow.id, new IfImpl(ifConfig == null ? Collections.emptyList() : ifConfig), new ThenImpl(thenConfig == null ? Collections.emptyList() : thenConfig));
    }

    public List<IfThen> getAllForRuleWithId(long ruleId) {
        List returnedRows = (List)this.databaseAccessor.run(connection -> ((SQLQuery)((SQLQuery)((SQLQuery)connection.select(QueryDslDaoHelper.constructor(QIfThen.Row.class, Tables.IF_THEN)).from((Expression)Tables.IF_THEN)).where((Predicate)Tables.IF_THEN.RULE_ID.eq((Object)ruleId))).orderBy(Tables.IF_THEN.ORDINAL.asc())).fetch());
        if (returnedRows.isEmpty()) {
            return Collections.emptyList();
        }
        return this.loadIfThensFromDbRows(returnedRows);
    }

    private List<IfThen> loadIfThensFromDbRows(List<QIfThen.Row> dbRows) {
        ImmutableList.Builder loadedIfThens = ImmutableList.builder();
        for (QIfThen.Row row : dbRows) {
            loadedIfThens.add((Object)this.loadIfThenFromDbRow(row));
        }
        return loadedIfThens.build();
    }

    private IfThen loadIfThenFromDbRow(QIfThen.Row ifThenRow) {
        List<IfConditionConfiguration> ifConditionConfigsForRule = this.ifConditionConfigDao.getAllForIfThenWithId(ifThenRow.id);
        List<ThenActionConfiguration> thenActonConfigsForRule = this.thenActionConfigDao.getAllForIfThenWithId(ifThenRow.id);
        return new IfThenImpl(ifThenRow.id, new IfImpl(ifConditionConfigsForRule), new ThenImpl(thenActonConfigsForRule));
    }
}

