/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset;

import com.atlassian.fugue.Either;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.ozymandias.error.ModuleAccessError;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.api.commons.result.Unit;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.Rule;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSet;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.WhenHandlerProvidesService;
import com.atlassian.servicedesk.plugins.automation.api.execution.context.project.ProjectContext;
import com.atlassian.servicedesk.plugins.automation.api.experimental.serviceflags.PermissionCheckFlag;
import com.atlassian.servicedesk.plugins.automation.api.experimental.serviceflags.ServiceFlag;
import com.atlassian.servicedesk.plugins.automation.api.experimental.serviceflags.ServiceFlags;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.project.InternalRuleSetProjectContextConfigService;
import com.atlassian.servicedesk.plugins.automation.internal.module.WhenHandlerProvidesManager;
import com.atlassian.servicedesk.plugins.automation.internal.permission.AutomationPermissionManager;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class WhenHandlerProvidesServiceImpl
implements WhenHandlerProvidesService {
    private AutomationPermissionManager automationPermissionManager;
    private InternalRuleSetProjectContextConfigService ruleSetProjectContextService;
    private WhenHandlerProvidesManager whenHandlerProvidesManager;
    private ErrorResultHelper errorResultHelper;

    @Autowired
    public WhenHandlerProvidesServiceImpl(AutomationPermissionManager automationPermissionManager, InternalRuleSetProjectContextConfigService ruleSetProjectContextService, WhenHandlerProvidesManager whenHandlerProvidesManager, ErrorResultHelper errorResultHelper) {
        this.automationPermissionManager = automationPermissionManager;
        this.ruleSetProjectContextService = ruleSetProjectContextService;
        this.whenHandlerProvidesManager = whenHandlerProvidesManager;
        this.errorResultHelper = errorResultHelper;
    }

    public Either<AnError, List<Set<String>>> retrieveProvides(@Nonnull ApplicationUser user, @Nonnull RuleSet ruleSet, @Nonnull ServiceFlags serviceFlags) {
        return StepsConverters.olderEither((io.atlassian.fugue.Either)this.checkViewPermission(user, ruleSet, serviceFlags).flatMap(passed -> this.getProvidesFromRuleWhenHandlers(user, ruleSet)));
    }

    private io.atlassian.fugue.Either<AnError, List<Set<String>>> getProvidesFromRuleWhenHandlers(ApplicationUser user, RuleSet ruleSet) {
        ArrayList<Object> ruleProvidesList = new ArrayList<Object>();
        for (Rule rule : ruleSet.getRules()) {
            io.atlassian.fugue.Either<? extends ModuleAccessError, Set<String>> providesResult = this.whenHandlerProvidesManager.retrieveProvides(user, rule);
            if (providesResult.isLeft()) {
                return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.internalServiceError500("sd.automation.rule.when.handler.provides.error", new Object[]{ruleSet.getId(), ((ModuleAccessError)providesResult.left().get()).getErrorMessage()}).build());
            }
            ruleProvidesList.add(providesResult.right().get());
        }
        return io.atlassian.fugue.Either.right(ruleProvidesList);
    }

    private io.atlassian.fugue.Either<AnError, Unit> checkViewPermission(ApplicationUser user, RuleSet ruleSet, ServiceFlags flags) {
        if (((PermissionCheckFlag)flags.get(PermissionCheckFlag.class, (ServiceFlag)PermissionCheckFlag.PERFORM_PERMISSION_CHECK)).isPerformPermissionCheck()) {
            return this.ruleSetProjectContextService.getProjectContext(ruleSet).flatMap(projectContext -> this.checkViewPermission(user, (ProjectContext)projectContext));
        }
        return io.atlassian.fugue.Either.right((Object)Unit.UNIT);
    }

    private io.atlassian.fugue.Either<AnError, Unit> checkViewPermission(ApplicationUser user, ProjectContext projectContext) {
        boolean hasViewRuleSetPermission = this.automationPermissionManager.hasViewRuleSetPermission(user, (Option<ProjectContext>)Option.some((Object)projectContext));
        return this.automationPermissionManager.toEither(user, hasViewRuleSetPermission);
    }
}

