/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset;

import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.IfConditionConfiguration;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ThenActionConfiguration;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.WhenHandlerConfiguration;
import com.atlassian.util.concurrent.Assertions;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

@Immutable
public class ComponentConfigurationImpl
implements ThenActionConfiguration,
IfConditionConfiguration,
WhenHandlerConfiguration {
    private final long id;
    protected final String moduleKey;
    protected final ConfigurationData data;

    public ComponentConfigurationImpl(long id, @Nonnull String moduleKey, @Nonnull ConfigurationData data) {
        Assertions.notNull((String)"moduleKey is required", (Object)moduleKey);
        Assertions.isTrue((String)"moduleKey is required", (boolean)StringUtils.isNotBlank((String)moduleKey));
        Assertions.notNull((String)"data is required", (Object)data);
        this.id = id;
        this.moduleKey = moduleKey;
        this.data = data;
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    public String getModuleKey() {
        return this.moduleKey;
    }

    @Nonnull
    public ConfigurationData getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentConfigurationImpl that = (ComponentConfigurationImpl)o;
        if (this.id != that.id) {
            return false;
        }
        if (!this.data.equals(that.data)) {
            return false;
        }
        return this.moduleKey.equals(that.moduleKey);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + this.moduleKey.hashCode();
        result = 31 * result + this.data.hashCode();
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", this.id).append("moduleKey", (Object)this.moduleKey).append("data", (Object)this.data).toString();
    }
}

