/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.configuration.project.dao.querydsl;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.BuilderService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RunAsUserContextConfig;
import com.atlassian.servicedesk.plugins.automation.api.configuration.user.RunAsUserContextConfigFactory;
import com.atlassian.servicedesk.plugins.automation.internal.bootstrap.database.schema.querydsl.QProjectUserContext;
import com.atlassian.servicedesk.plugins.automation.internal.bootstrap.database.schema.querydsl.Tables;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.common.dao.QueryDslDao;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.common.dao.QueryDslDaoHelper;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.project.dao.ProjectUserContextDao;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.project.dao.querydsl.ProjectUserContextDaoException;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.user.RunAsUserContextConfigDataExtractor;
import com.atlassian.util.concurrent.Assertions;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import io.atlassian.fugue.Option;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectUserContextDaoImpl
extends QueryDslDao
implements ProjectUserContextDao {
    private final RunAsUserContextConfigFactory runAsUserContextConfigFactory;

    @Autowired
    protected ProjectUserContextDaoImpl(DatabaseAccessor databaseAccessor, QueryDslDaoHelper helper, BuilderService builderService) {
        super(databaseAccessor, helper);
        this.runAsUserContextConfigFactory = builderService.newRunAsUserContextConfigFactory();
    }

    @Override
    public void setRunAsUserContextConfigForProject(long projectId, @Nonnull RunAsUserContextConfig runAsUserContextConfig) {
        Assertions.notNull((String)"runAsUserContextConfig", (Object)runAsUserContextConfig);
        RunAsUserContextConfigDataExtractor.RunAsUserContextConfigData userContextConfigData = this.extractUserContextData(runAsUserContextConfig);
        long rowsUpdated = (Long)this.databaseAccessor.runInTransaction(connection -> connection.query().merge((RelationalPath)Tables.PROJECT_USER_CONTEXT).keys(new Path[]{Tables.PROJECT_USER_CONTEXT.PROJECT_ID}).set(Tables.PROJECT_USER_CONTEXT.PROJECT_ID, (Object)projectId).set((Path)Tables.PROJECT_USER_CONTEXT.STRATEGY, (Object)userContextConfigData.strategyName).set((Path)Tables.PROJECT_USER_CONTEXT.USER_KEY, userContextConfigData.userKey.getOrNull()).execute());
        this.checkSingleRowUpdated(rowsUpdated, projectId);
    }

    private void checkSingleRowUpdated(long rowsUpdated, long projectId) {
        if (rowsUpdated != 1L) {
            throw new ProjectUserContextDaoException(String.format("Error when creating or updating the stored RunAsUserContextConfig for project with id '%d'. Expected 1 row update, but %d were updated.", projectId, rowsUpdated));
        }
    }

    private RunAsUserContextConfigDataExtractor.RunAsUserContextConfigData extractUserContextData(RunAsUserContextConfig runAsUserContextConfig) {
        return RunAsUserContextConfigDataExtractor.extract(runAsUserContextConfig);
    }

    @Override
    public Option<RunAsUserContextConfig> getContextConfigForProject(long projectId) {
        QProjectUserContext.Row userContextRow = (QProjectUserContext.Row)this.databaseAccessor.run(connection -> (QProjectUserContext.Row)((SQLQuery)((SQLQuery)connection.select(QueryDslDaoHelper.constructor(QProjectUserContext.Row.class, Tables.PROJECT_USER_CONTEXT)).from((Expression)Tables.PROJECT_USER_CONTEXT)).where((Predicate)Tables.PROJECT_USER_CONTEXT.PROJECT_ID.eq((Object)projectId))).fetchOne());
        if (userContextRow == null) {
            return Option.none();
        }
        RunAsUserContextConfig parsedFromRow = this.runAsUserContextConfigFactory.forStrategyNameAndUserKey(userContextRow.strategy, StepsConverters.olderOption((Option)Option.option((Object)userContextRow.userKey)));
        return Option.option((Object)parsedFromRow);
    }

    @Override
    public void deleteContextConfigForProject(long projectId) {
        this.databaseAccessor.run(connection -> connection.delete((RelationalPath)Tables.PROJECT_USER_CONTEXT).where((Predicate)Tables.PROJECT_USER_CONTEXT.PROJECT_ID.eq((Object)projectId)).execute());
    }
}

