/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.internal.configuration.common.dao;

import com.atlassian.pocketknife.api.querydsl.DatabaseCompatibilityKit;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.plugins.automation.internal.configuration.ruleset.dao.RuleSetDaoException;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.ExecutionResult;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.ExecutionResultImpl;
import com.atlassian.servicedesk.plugins.automation.internal.execution.history.dao.ExecutionHistoryDaoException;
import com.querydsl.core.dml.DMLClause;
import com.querydsl.core.types.ConstructorExpression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import io.atlassian.fugue.Option;
import java.sql.Timestamp;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QueryDslDaoHelper {
    private final DatabaseCompatibilityKit inserterThatSupportsHsql;

    @Autowired
    QueryDslDaoHelper(DatabaseCompatibilityKit inserterThatSupportsHsql) {
        this.inserterThatSupportsHsql = inserterThatSupportsHsql;
    }

    public <C extends DMLClause<C>> long executeWithExceptionMessage(DMLClause<C> toExecute, String exceptionMessage) {
        try {
            return toExecute.execute();
        }
        catch (RuntimeException e) {
            throw new RuleSetDaoException(exceptionMessage, e);
        }
    }

    public <C extends DMLClause<C>> void executeExpectingNRowUpdates(DMLClause<C> toExecute, long expectedRowUpdateCount, String exceptionMessage) {
        long actualRowUpdateCount = this.executeWithExceptionMessage(toExecute, exceptionMessage);
        if (expectedRowUpdateCount != actualRowUpdateCount) {
            String misMatchedRowUpdatesMessage = String.format("Expected %d %s to be updated, but %d %s updated", expectedRowUpdateCount, expectedRowUpdateCount == 1L ? "row" : "rows", actualRowUpdateCount, actualRowUpdateCount == 1L ? "was" : "were");
            throw new RuleSetDaoException(exceptionMessage + " " + misMatchedRowUpdatesMessage);
        }
    }

    public long executeSingleRowInsertReturningId(DatabaseConnection connection, SQLInsertClause insertClause, String exceptionMessage) {
        Long idOfNewlyInsertedItem;
        try {
            idOfNewlyInsertedItem = (Long)this.inserterThatSupportsHsql.executeWithKey(connection, insertClause, Long.class);
        }
        catch (RuntimeException e) {
            throw new RuleSetDaoException(exceptionMessage, e);
        }
        if (idOfNewlyInsertedItem == null) {
            throw new RuleSetDaoException(exceptionMessage + " No rows were inserted.");
        }
        return idOfNewlyInsertedItem;
    }

    public <T> Option<T> getSingleResultForColumnIdMatch(RelationalPathBase<?> table, NumberPath<Long> idMatchColumn, long idToMatch, Class<T> rowType, DatabaseConnection connectionToUse) {
        Object resultRow = ((SQLQuery)((SQLQuery)connectionToUse.select(QueryDslDaoHelper.constructor(rowType, table)).from(table)).where((Predicate)idMatchColumn.eq((Object)idToMatch))).fetchOne();
        return Option.option((Object)resultRow);
    }

    public <T> List<T> getMultipleOrderedResultsForColumnIdMatch(RelationalPathBase<?> table, NumberPath<Long> idMatchColumn, long idToMatch, Class<T> rowType, DatabaseConnection connectionToUse, OrderSpecifier<?> orderSpecifier) {
        return ((SQLQuery)((SQLQuery)((SQLQuery)connectionToUse.select(QueryDslDaoHelper.constructor(rowType, table)).from(table)).where((Predicate)idMatchColumn.eq((Object)idToMatch))).orderBy(orderSpecifier)).fetch();
    }

    public static Timestamp now() {
        return new Timestamp(DateTimeUtils.currentTimeMillis());
    }

    public static <T> ConstructorExpression<T> constructor(Class<? extends T> type, RelationalPath<?> path) {
        return Projections.constructor(type, QueryDslDaoHelper.asArray(path.getColumns()));
    }

    public static Path<?>[] asArray(List<Path<?>> columns) {
        return columns.toArray(new Path[columns.size()]);
    }

    public static <T extends Enum> ExecutionResult<T> constructExecutionResult(String outcomeAsString, Class<T> expectedOutcomeType, String message) {
        T outcome;
        try {
            outcome = Enum.valueOf(expectedOutcomeType, outcomeAsString);
        }
        catch (IllegalArgumentException e) {
            throw new ExecutionHistoryDaoException(String.format("Unable to load a %s from database. '%s' is not a valid outcome.", expectedOutcomeType, outcomeAsString));
        }
        return new ExecutionResultImpl<T>(outcome, (Option<String>)Option.option((Object)message));
    }

    public static DateTime convertLongToDateTime(Long toConvert) {
        return new DateTime(toConvert != null ? toConvert : 0L);
    }
}

