/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.service.request.requesttype;

import com.atlassian.annotations.Internal;
import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.portal.PortalService;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.requesttype.RequestTypeQueryParameters;
import com.atlassian.servicedesk.api.requesttype.RequestTypeService;
import com.atlassian.servicedesk.plugins.automation.modules.permission.AutomationJiraPermissionChecker;
import com.atlassian.servicedesk.plugins.automation.modules.service.request.requesttype.AutomationRequestTypeService;
import com.atlassian.util.concurrent.Assertions;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
@Internal
public class AutomationRequestTypeServiceImpl
implements AutomationRequestTypeService {
    private final ProjectService projectService;
    private final PortalService portalService;
    private final RequestTypeService requestTypeService;
    private final AutomationJiraPermissionChecker permissionManager;
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    public AutomationRequestTypeServiceImpl(ProjectService projectService, PortalService portalService, RequestTypeService requestTypeService, AutomationJiraPermissionChecker permissionManager, ErrorResultHelper errorResultHelper) {
        this.projectService = projectService;
        this.portalService = portalService;
        this.requestTypeService = requestTypeService;
        this.permissionManager = permissionManager;
        this.errorResultHelper = errorResultHelper;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, List<RequestType>> getRequestTypes(ApplicationUser user, String projectKey) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"projectKey", (Object)projectKey);
        if (!this.permissionManager.hasProjectAdminPermission(user)) {
            return StepsConverters.newerEither((Either)this.errorResultHelper.error(user, HttpStatusCode.FORBIDDEN, "sd.automation.module.no.permission.error", new Object[0]));
        }
        ProjectService.GetProjectResult projectResult = this.projectService.getProjectByKey(user, projectKey);
        if (!projectResult.isValid()) {
            return StepsConverters.newerEither((Either)this.errorResultHelper.error(user, HttpStatusCode.FORBIDDEN, "sd.action.request.type.project.permission", new Object[]{projectKey}));
        }
        Project project = projectResult.getProject();
        io.atlassian.fugue.Either portalEither = StepsConverters.newerEither((Either)this.portalService.getPortalForProject(user, project));
        if (portalEither.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)portalEither.left().get());
        }
        Portal portal = (Portal)portalEither.right().get();
        RequestTypeQueryParameters requestTypeQueryParameters = this.requestTypeService.queryBuilder().portal(portal).build();
        return StepsConverters.newerEither((Either)this.requestTypeService.getRequestTypes(user, requestTypeQueryParameters));
    }
}

