/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.automation.modules.rulewhen;

import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.feature.reqparticipants.NewlyAddedParticipantsHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.command.RuleExecutionCommand;
import com.atlassian.servicedesk.plugins.automation.api.execution.command.RuleExecutionCommandBuilder;
import com.atlassian.servicedesk.plugins.automation.api.execution.command.RuleExecutionCommandBuilderService;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilder;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessageBuilderService;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.EventTimeMessageHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.IssueMessageHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.helper.UserMessageHelper;
import com.atlassian.servicedesk.plugins.automation.api.execution.whenhandler.WhenHandlerContext;
import com.atlassian.servicedesk.plugins.automation.modules.internal.api.rulewhen.helper.ParticipantsMessageHelper;
import com.atlassian.servicedesk.plugins.automation.modules.rulewhen.WhenUtils;
import com.atlassian.servicedesk.plugins.automation.spi.rulewhen.event.EventWhenHandler;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewParticipantsEventWhenHandler
implements EventWhenHandler<IssueEvent> {
    private static final Logger log = LoggerFactory.getLogger(NewParticipantsEventWhenHandler.class);
    private final RuleMessageBuilderService ruleMessageBuilderService;
    private final IssueMessageHelper issueMessageHelper;
    private final UserMessageHelper userMessageHelper;
    private final ParticipantsMessageHelper participantsMessageHelper;
    private final EventTimeMessageHelper eventTimeMessageHelper;
    private final WhenUtils whenUtils;
    private final RuleExecutionCommandBuilderService ruleExecutionCommandBuilderService;
    private final NewlyAddedParticipantsHelper newlyAddedParticipantsHelper;

    public NewParticipantsEventWhenHandler(RuleMessageBuilderService ruleMessageBuilderService, IssueMessageHelper issueMessageHelper, UserMessageHelper userMessageHelper, ParticipantsMessageHelper participantsMessageHelper, EventTimeMessageHelper eventTimeMessageHelper, WhenUtils whenUtils, RuleExecutionCommandBuilderService ruleExecutionCommandBuilderService, NewlyAddedParticipantsHelper newlyAddedParticipantsHelper) {
        this.ruleMessageBuilderService = ruleMessageBuilderService;
        this.issueMessageHelper = issueMessageHelper;
        this.userMessageHelper = userMessageHelper;
        this.participantsMessageHelper = participantsMessageHelper;
        this.eventTimeMessageHelper = eventTimeMessageHelper;
        this.whenUtils = whenUtils;
        this.ruleExecutionCommandBuilderService = ruleExecutionCommandBuilderService;
        this.newlyAddedParticipantsHelper = newlyAddedParticipantsHelper;
    }

    public Class<IssueEvent> getEventClass() {
        return IssueEvent.class;
    }

    public List<RuleExecutionCommand> handleEvent(@Nonnull List<WhenHandlerContext> contexts, @Nonnull IssueEvent event) {
        List newParticipants = this.newlyAddedParticipantsHelper.getNewParticipants(event);
        if (newParticipants.isEmpty()) {
            return Collections.emptyList();
        }
        log.debug("Handling ParticipantsAddedEvent event. # of contexts found: {}", (Object)contexts.size());
        return this.buildRuleExecutionCommands(contexts, event, newParticipants);
    }

    private List<RuleExecutionCommand> buildRuleExecutionCommands(List<WhenHandlerContext> contexts, IssueEvent event, List<CheckedUser> newParticipants) {
        if (event.getIssue() == null) {
            log.warn("Received issue event with no issue");
            return Collections.emptyList();
        }
        Date eventTime = NewParticipantsEventWhenHandler.dateOrNow(event.getTime());
        Option authorOpt = Option.option((Object)event.getUser());
        RuleExecutionCommandBuilder builder = this.ruleExecutionCommandBuilderService.builder().ruleMessage(this.createRuleMessage(event.getIssue(), eventTime, (Option<ApplicationUser>)authorOpt, newParticipants));
        return contexts.stream().filter(context -> this.whenUtils.matchContextWithPermissionCheck((WhenHandlerContext)context, event.getIssue())).map(context -> builder.ruleReference(context.getRuleReference()).build()).collect(Collectors.toList());
    }

    private RuleMessage createRuleMessage(Issue issue, Date eventTime, Option<ApplicationUser> authorOpt, List<CheckedUser> newParticipants) {
        RuleMessageBuilder builder = this.ruleMessageBuilderService.builder();
        authorOpt.forEach(author -> this.userMessageHelper.setUser(builder, "currentUser", author));
        this.issueMessageHelper.setIssueData(builder, issue);
        this.eventTimeMessageHelper.setEventTime(builder, NewParticipantsEventWhenHandler.dateOrNow(eventTime));
        this.participantsMessageHelper.setNewParticipants(builder, this.toUserKeys(newParticipants));
        return builder.build();
    }

    private Set<String> toUserKeys(List<CheckedUser> users) {
        return users.stream().map(checkedUser -> checkedUser.forJIRA().getKey()).collect(Collectors.toSet());
    }

    private static Date dateOrNow(Date nullableDate) {
        return (Date)Option.option((Object)nullableDate).getOrElse((Object)new Date());
    }
}

